/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _STUB_RADIOBUTTON_H_
#define _STUB_RADIOBUTTON_H_

#include <mforms/radiobutton.h>


#include "stub_view.h"
#include "stub_panel.h"

namespace mforms {
namespace stub {
  
class RadioButtonImpl : public ButtonImpl
{
 protected:
  RadioButtonImpl(::mforms::RadioButton *self, int group_id)
    : ButtonImpl(self)
  {
  }
  
  virtual ~RadioButtonImpl()
  {
  }


  static void __stdcall callback(::mforms::RadioButton* self)
  {
  }

  static bool __stdcall create(::mforms::RadioButton *self, int group_id)
  {
    return true;
  }

  static bool __stdcall get_active(::mforms::RadioButton *self)
  {
    return false;
  }
  
  
  static void __stdcall set_active(::mforms::RadioButton *self, bool flag)
  {
  }

public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_radio_impl.create= &RadioButtonImpl::create;
    f->_radio_impl.get_active= &RadioButtonImpl::get_active;
    f->_radio_impl.set_active= &RadioButtonImpl::set_active;
  }
};

}
}


#endif /* _STUB_RADIOBUTTON_H_ */
