/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _STUB_SCROLL_PANEL_H_
#define _STUB_SCROLL_PANEL_H_


#include "mforms/scrollpanel.h"

#include "stubi_container.h"

namespace mforms
{
namespace stub
{

class ScrollPanelImpl : public ContainerImpl
{
protected:
  ScrollPanelImpl(::mforms::ScrollPanel *self, bool bordered)
    : ContainerImpl(self)
  {
  }

  static bool __stdcall create(::mforms::ScrollPanel *self, ::mforms::ScrollPanelFlags flags)
  {
    return true;
  }

  static void __stdcall add(::mforms::ScrollPanel *self, ::mforms::View *child)
  {
  }

  static void __stdcall remove(::mforms::ScrollPanel *self)
  {
  }

  static void __stdcall set_visible_scrollers(::mforms::ScrollPanel *self, bool vertical, bool horizontal)
  {
  }

  static void __stdcall set_autohide_scrollers(::mforms::ScrollPanel *self, bool flag)
  {
  }

 public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_spanel_impl.create         = &ScrollPanelImpl::create;

    f->_spanel_impl.add            = &ScrollPanelImpl::add;
    f->_spanel_impl.remove         = &ScrollPanelImpl::remove;    
    f->_spanel_impl.set_visible_scrollers  = &ScrollPanelImpl::set_visible_scrollers;    
    f->_spanel_impl.set_autohide_scrollers = &ScrollPanelImpl::set_autohide_scrollers;    
  }
};

};
};


#endif
