/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _STUB_SPLITTER_H_
#define _STUB_SPLITTER_H_

#include "mforms/splitter.h"

#include "stub_view.h"


namespace mforms {
namespace stub {

class SplitterImpl : public ViewImpl
{  
protected:
  SplitterImpl(::mforms::Splitter *self, bool horiz)
    : ViewImpl(self)
  {
  }

  static bool __stdcall create(::mforms::Splitter *self, bool horiz)
  {
    return true;
  }

  static void __stdcall add(Splitter *self, View *child, int minwidth)
  {
  }

  static void __stdcall remove(Splitter *self, View *child)
  {
  }
  
  static void __stdcall set_position(Splitter *self, int pos)
  {
  }

public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_splitter_impl.create= &SplitterImpl::create;
    f->_splitter_impl.add= &SplitterImpl::add;
    f->_splitter_impl.remove= &SplitterImpl::remove;
    f->_splitter_impl.set_position= &SplitterImpl::set_position;
  }
  
  virtual ~SplitterImpl()
  {
  }
};

}
}


#endif /* _STUB_SPLITTER_H_ */
