/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WF_LABEL_H_
#define _WF_LABEL_H_

#include "mforms/label.h"

#include "wf_view.h"

namespace MySQL {
  namespace Forms {

    /**
     * Defines a label with an auto wrapping feature.
     */
    private ref class WrapControlLabel : Label
    {
    private:
      bool _auto_wrapping;
    public:
      WrapControlLabel();

      property bool AutoWrapping
      {
        bool get() { return _auto_wrapping; };
        void set(bool value) { _auto_wrapping= value; };
      }

      virtual Drawing::Size GetPreferredSize(Drawing::Size proposedSize) override;
    };

    /**
     * Windows wrapper class for the mforms label control.
     */
    public ref class LabelImpl : public ViewImpl
    {
    protected:
      static bool create(::mforms::Label *self);
      static void set_style(::mforms::Label *self, ::mforms::LabelStyle style);
      static void set_text(::mforms::Label *self, const std::string &text);
      static void set_text_align(::mforms::Label *self, ::mforms::Alignment align);
      static void set_color(::mforms::Label *self, const std::string &color);
      static void set_wrap_text(::mforms::Label *self, bool flag);
    public:
      LabelImpl(::mforms::Label *self);

      void set_style(::mforms::LabelStyle style);
      void set_text(const std::string &text);
      void set_text_align(::mforms::Alignment align);
      void set_color(const std::string &color);
      void set_wrap_text(bool flag);

      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK1(bool, ::mforms::Label*, mgr, f->_label_impl, LabelImpl, create);
        DEF_CALLBACK2(void, ::mforms::Label*, const std::string&, mgr, f->_label_impl, LabelImpl, set_text);
        DEF_CALLBACK2(void, ::mforms::Label*, ::mforms::LabelStyle, mgr, f->_label_impl, LabelImpl, set_style);
        DEF_CALLBACK2(void, ::mforms::Label*, ::mforms::Alignment, mgr, f->_label_impl, LabelImpl, set_text_align);
        DEF_CALLBACK2(void, ::mforms::Label*, const std::string&, mgr, f->_label_impl, LabelImpl, set_color);
        DEF_CALLBACK2(void, ::mforms::Label*, bool, mgr, f->_label_impl, LabelImpl, set_wrap_text);
      }
    };

  };
};


#endif
