/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WF_PROGRESSBAR_H_
#define _WF_PROGRESSBAR_H_

#include <mforms/mforms.h>

#include "wf_view.h"


using namespace System;
using namespace Windows::Forms;

namespace MySQL {
  namespace Forms {

    public ref class ProgressBarImpl : public ViewImpl
    {
      static bool create(::mforms::ProgressBar *self)
      {
        ProgressBarImpl ^cb= gcnew ProgressBarImpl(self);

        if (cb != nullptr)
        {
          ProgressBar ^pb= ViewImpl::create<ProgressBar>(self, cb);
          pb->Maximum= 1000;
          pb->Minimum= 0;
          pb->Size= Size(100, 20);
          return true;
        }
        return false;
      }

      static void set_value(::mforms::ProgressBar *self, float pct)
      {
        ProgressBarImpl^ cb= (ProgressBarImpl^)ObjectImpl::FromUnmanaged(self);

        if (cb != nullptr)
          cb->get_control<ProgressBar>()->Value= (int) (pct * 1000);
      }

      static void set_indeterminate(::mforms::ProgressBar *self, bool flag)
      {
        ProgressBarImpl^ cb= (ProgressBarImpl^)ObjectImpl::FromUnmanaged(self);

        if (cb != nullptr)
          cb->get_control<ProgressBar>()->Value= 0;
      }

      static void set_started(::mforms::ProgressBar *self, bool flag)
      {
        ProgressBarImpl^ cb= (ProgressBarImpl^)ObjectImpl::FromUnmanaged(self);

        if (cb != nullptr)
          cb->get_control<ProgressBar>()->Value= 0;
      }

      ProgressBarImpl(::mforms::ProgressBar *pbar)
        : ViewImpl(pbar)
      {
      }

    public:
      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK1(bool, ::mforms::ProgressBar*, mgr, f->_progressbar_impl, ProgressBarImpl, create);
        DEF_CALLBACK2(void, ::mforms::ProgressBar*, float, mgr, f->_progressbar_impl, ProgressBarImpl, set_value);
        DEF_CALLBACK2(void, ::mforms::ProgressBar*, bool, mgr, f->_progressbar_impl, ProgressBarImpl, set_indeterminate);
        DEF_CALLBACK2(void, ::mforms::ProgressBar*, bool, mgr, f->_progressbar_impl, ProgressBarImpl, set_started);
      }
    };

  };
};

#endif
