/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WF_SPLITTER_H_
#define _WF_SPLITTER_H_

#include "wf_view.h"

using namespace System::Collections;

namespace MySQL
{
  namespace Forms
  {
    public ref class SplitterImpl : public ViewImpl
    {
    private:
      int pendingSplitterDistance;
    protected:
      SplitterImpl(::mforms::Splitter *self);

      void set_position(int position);
      int get_position();

      static bool create(::mforms::Splitter *self, bool horizontal);
      static void add(::mforms::Splitter *self, ::mforms::View *view, int min_size);
	    static void remove(::mforms::Splitter *self, ::mforms::View *view);
	    static void set_position(::mforms::Splitter *self, int position);
      static int get_position(::mforms::Splitter *self);
      static void set_expanded(::mforms::Splitter *self, bool first, bool expand);

      static void on_paint(System::Object ^sender, PaintEventArgs ^e);
    public:
      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK2(bool, ::mforms::Splitter*, bool, mgr, f->_splitter_impl, SplitterImpl, create);
		    DEF_CALLBACK3(void, ::mforms::Splitter*, ::mforms::View*, int, mgr, f->_splitter_impl, SplitterImpl, add);
		    DEF_CALLBACK2(void, ::mforms::Splitter*, ::mforms::View*, mgr, f->_splitter_impl, SplitterImpl, remove);
		    DEF_CALLBACK2(void, ::mforms::Splitter*, int, mgr, f->_splitter_impl, SplitterImpl, set_position);
        DEF_CALLBACK1(int, ::mforms::Splitter*, mgr, f->_splitter_impl, SplitterImpl, get_position);
        DEF_CALLBACK3(void, ::mforms::Splitter*, bool, bool, mgr, f->_splitter_impl, SplitterImpl, set_expanded);
      }
    };
  };
};

#endif
