/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _GRT_DIFF_H
#define _GRT_DIFF_H

#include "grtpp.h"
#include "grtpp_util.h"

namespace grt
{
class ValueRef;
class BaseListRef;
class DictRef;
//class ObjectRef;
class DiffChange;


class GrtDiff
{
protected:
  const Omf* omf;
  virtual DiffChange *on_list(DiffChange *parent, const BaseListRef &source, const BaseListRef &target, const TSlotNormalizerSlot sqlDefinitionCmp);
  virtual DiffChange *on_dict(DiffChange *parent, const DictRef &source, const DictRef &target, const TSlotNormalizerSlot sqlDefinitionCmp);
  virtual DiffChange *on_object(DiffChange *parent, const ObjectRef &source, const ObjectRef &target,const TSlotNormalizerSlot sqlDefinitionCmp);

  virtual DiffChange *on_uncompatible(DiffChange *parent, const ValueRef &source, const ValueRef &target);

  std::string trim_zeros(const std::string& str)const;
  std::string fixDefalutString(const std::string& str)const;

  DiffChange *on_value(DiffChange *parent, const ValueRef &source, const ValueRef &target, const TSlotNormalizerSlot sqlDefinitionCmp);
public:
  GrtDiff() : omf(NULL) {};
  DiffChange *diff(const ValueRef &source, const ValueRef &target, const Omf* omf,const TSlotNormalizerSlot sqlDefinitionCmp);
  virtual ~GrtDiff() {}
};

}

#endif
