/*!
 Copyright 2009 Sun Microsystems, Inc.
 
 @author
 jak
 
 @class
 MacTableEditorColumnsInformationSource
 
 @abstract
 The purpose of this class is to insulate the C++ data structures needed by the MySQL Table Editor.
 
 @ingroup
 MySQL Table Editor
 */



#import "MacTableEditorColumnsInformationSource.h"

#include "mysql_table_editor.h"
#import "GRTIconCache.h"



@implementation MacTableEditorColumnsInformationSource



- (NSArray*) columnFlagsForRow: (NSInteger) rowIndex;
{
  NSAssert(mBackEnd != nil, @"The mBackEnd must not be nil.");
  
  NSMutableArray* flagNames = [NSMutableArray array];
  
  const ::bec::NodeId& node = mBackEnd->get_columns()->get_node(rowIndex);
  std::vector<std::string> flags(mBackEnd->get_columns()->get_datatype_flags(node));
  
  std::vector<std::string>::const_iterator it = flags.begin();
  std::vector<std::string>::const_iterator last = flags.end();
  for (; last != it; ++it) {
    bool isChecked = mBackEnd->get_columns()->get_column_flag(node, *it);
    std::string flagTitle = *it;
    [flagNames addObject: [NSString stringWithUTF8String: flagTitle.c_str()]];
    [flagNames addObject: [NSNumber numberWithBool: isChecked]];
  }
  
  return flagNames;
}



- (void) setFlag: (BOOL) yn
     forFlagName: (NSString*) flagName
   atColumnIndex: (int) columnIndex;
{
  NSAssert(mBackEnd != nil, @"The mBackEnd must not be nil.");
  
  const ::bec::NodeId& node = mBackEnd->get_columns()->get_node(columnIndex);
  const std::string flag_name = [flagName UTF8String];
  mBackEnd->get_columns()->set_column_flag(node, flag_name, (yn == YES ? 1 : 0) );
}



- (NSImage*) iconAtRow: (NSInteger) rowIndex;
{
  int icon_id = [self listModel]->get_field_icon(rowIndex, bec::TableColumnsListBE::Name, bec::Icon16);
  NSImage* img = [[GRTIconCache sharedIconCache] imageForIconId: icon_id];
  
  return img;
}



- (id) initWithListModel: (bec::ListModel*) model
            tableBackEnd: (MySQLTableEditorBE*) tableBackend;
{
  self = [self initWithListModel: model];
  
  if (self != nil) {
    mBackEnd = tableBackend;
  }
  
  return self;
}



- (void) moveColumnAtRow: (NSInteger) from
                   toRow: (NSInteger) to;
{
  const ::bec::NodeId& node = mBackEnd->get_columns()->get_node(from);
  [self listModel]->reorder(node, to);
}



@end


