using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Aga.Controls.Tree;

using MySQL.Grt;
using MySQL.Utilities;
using MySQL.Grt.Db;

namespace MySQL.GUI.Workbench.Plugins
{
  public partial class DbMysqlUserEditor : ObjectEditorPlugin
  {
    #region Member Variables

    private UserEditorBE userEditorBE { get { return editorBE as UserEditorBE; } } 
    private RoleTreeBE roleTreeBE;
    //private SimpleGrtTreeModel roleTreeModel;
    private DifferenceByNameGrtTreeModel roleTreeModel;

    #endregion

    #region Constructors

    public DbMysqlUserEditor()
    {
      InitializeComponent();
    }

    public DbMysqlUserEditor(GrtManager GrtManager, GrtValue GrtObject)
      : base(new UserEditorBE(GrtManager, GrtObject))
    {
      InitializeComponent();

      // Init BE

      InitializingControls = true;
      try
      {
        nameTextBox.Text = userEditorBE.get_name();
        passwordTextBox.Text = userEditorBE.get_password();
        commentTextBox.Text = userEditorBE.get_comment();

        roleTreeBE = userEditorBE.get_role_tree();
        roleTreeBE.refresh();

        roleTreeModel = new DifferenceByNameGrtTreeModel(roleTreeView, new List<String>(), roleTreeBE, false);
        roleTreeModel.AddColumn(roleTreeNodeText, (int)RoleTreeBE.Columns.Name, false);
        roleTreeView.Model = roleTreeModel;

        RefreshAssignedRoles();
      }
      finally
      {
        InitializingControls = false;
      }

      TabText = nameTextBox.Text;
    }

    #endregion

    #region Form implemenation

    private void RefreshAssignedRoles()
    {
      List<String> selectedRoles = new List<String>();

      assignedRoleList.Items.Clear();
      foreach (String role in userEditorBE.get_roles())
      {
        assignedRoleList.Items.Add(role);
        selectedRoles.Add(role);
      }

      roleTreeModel.SetDisabledList(selectedRoles);
      roleTreeView.Model = null;
      roleTreeView.Model = roleTreeModel;
    }

    private void addRoleButton_Click(object sender, EventArgs e)
    {
      foreach (TreeNodeAdv node in roleTreeView.SelectedNodes)
      {
        userEditorBE.add_role(node.ToString());
      }
      RefreshAssignedRoles();
    }

    private void removeRoleButton_Click(object sender, EventArgs e)
    {
      foreach (String node in assignedRoleList.SelectedItems)
      {
        userEditorBE.remove_role(node);
      }
      RefreshAssignedRoles();
    }

    private void nameTextBox_TextChanged(object sender, EventArgs e)
    {
      if (!InitializingControls)
        userEditorBE.set_name(nameTextBox.Text);

      TabText = nameTextBox.Text;
    }

    private void passwordTextBox_TextChanged(object sender, EventArgs e)
    {
      if (!InitializingControls)
        userEditorBE.set_password(passwordTextBox.Text);
    }

    void commentTextBox_TextChanged(object sender, System.EventArgs e)
    {
      if (!InitializingControls)
        userEditorBE.set_comment(commentTextBox.Text);
    }

    protected override void RefreshFormData() 
    {
      RefreshAssignedRoles();
    }

    #endregion
  }
}