#!/usr/bin/python
import sys
import xml.dom.minidom
import re
import pprint
import missing_info
import pprint
import options_struct
import raw_opts

tabs = []
opts = {}
olist = {}

for opt in raw_opts.ropts:
  opts[opt['name']] = opt
  olist[opt['name']] = opt

doc = xml.dom.minidom.parse('structure.xml')
for sec in doc.documentElement.getElementsByTagName('section'):
  if sec.nodeType == sec.ELEMENT_NODE and sec.getAttribute('name') == "Configuration":
    for tab in sec.childNodes:
      if tab.nodeType == tab.ELEMENT_NODE:
        tab_name = str(tab.getAttribute('caption'))
        tab_cont = []
        for grp in tab.childNodes:
          if grp.nodeType == grp.ELEMENT_NODE and grp.tagName == 'group':
            grp_name = str(grp.getAttribute('caption'))
            grp_cont = []

            content = options_struct.struct[tab_name][grp_name]
            for opt_name in content.keys():
              opt = opts.get(opt_name, None)
              grp_cont.append(opt)
              del olist[opt_name]

            tab_cont.append((grp_name, tuple(grp_cont)))
        tabs.append((tab_name, tuple(tab_cont)))

f = open('opts.py', 'w')
f.write("opts_list = ")
pp = pprint.PrettyPrinter(indent=2, stream=f)
pp.pprint(tuple(tabs))
f.close()

mo = olist.keys()
mo.sort()
for o in mo:
  v = olist[o]
  print o#, v['description']
  print "--"

for o in mo:
  print o
