//
//  WBModelNoteEditor.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 19/Feb/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "WBPluginEditorBase.h"

#include "wb_editor_note.h"



@interface NoteEditor : WBPluginEditorBase {
  IBOutlet NSTabView *tabView; // this editor has a single Tab, but we put in a TabView for homegeneity
  
  IBOutlet NSTextField *nameText;
  
  IBOutlet NSTextView *noteText;
  
  NoteEditorBE *mBackEnd; //!< note editor backend
  
  BOOL mEditing;
}

- (id)initWithModule:(grt::Module*)module GRTManager:(bec::GRTManager*)grtm arguments:(const grt::BaseListRef&)args;

- (NSView*)dockableView;

@end
