#include "stdafx.h"
#include "addon_manager.h"
#include "addon_manifest_loader.h"
#include "addon_downloader.h"
#include "addon_installer.h"
#include "addon_uninstaller.h"


const char *Addon_manager::INSTALLED_ADDONS_DIR= "addons/installed";
const char *Addon_manager::CACHED_ADDONS_DIR= "addons/cache";


Addon_manager::Addon_manager()
:
_log(Logger::default_instance())
{
}


Addon_manager::~Addon_manager()
{
}


void Addon_manager::load_installed_addons_repo()
{
  _installed_addons.log(_log);
  _installed_addons.storage_dir(_user_data_dir.path() + "/" + INSTALLED_ADDONS_DIR);
  _installed_addons.temp_dir(_temp_dir);
  _installed_addons.load();
}


void Addon_manager::load_cached_addons_repo()
{
  _cached_addons.log(_log);
  _cached_addons.storage_dir(_user_data_dir.path() + "/" + CACHED_ADDONS_DIR);
  _cached_addons.temp_dir(_temp_dir);
  _cached_addons.load();
}


void Addon_manager::get_installed_addons(std::list<std::string> &guids, std::list<std::string> &names)
{
  _installed_addons.get_names(guids, names);
}


void Addon_manager::load_manifest(const std::string &guid, const std::string &min_ver, const std::string &max_ver)
{
  try
  {
    Addon_manifest_loader proc;
    proc.log(_log);
    proc.temp_dir(_temp_dir);
    proc.cached_addons(&_cached_addons);
    proc.lookup_cached_addons(true);
    proc.fd(&_fd);
    proc.url_base(_url_base);
    proc.url_suffix(_url_suffix);
    proc.guid(guid);
    proc.min_ver(min_ver);
    proc.max_ver(max_ver);

    proc.execute();
  }
  catch(std::exception &e)
  {
    _log->push_err(e.what());
    throw;
  }
}


void Addon_manager::load_manifest_from_url(const std::string &url, std::string &guid, std::string &version)
{
  try
  {
    Addon_manifest_loader proc;
    proc.log(_log);
    proc.temp_dir(_temp_dir);
    proc.cached_addons(&_cached_addons);
    proc.lookup_cached_addons(true);
    proc.fd(&_fd);
    proc.url_base(_url_base);
    proc.url_suffix(_url_suffix);
    proc.url(url);

    proc.execute();

    guid= proc.guid();
    version= proc.min_ver();
  }
  catch(std::exception &e)
  {
    _log->push_err(e.what());
    throw;
  }
}


void Addon_manager::download(const std::string &guid, const std::string &version)
{
  try
  {
    Addon_downloader proc;
    proc.log(_log);
    proc.temp_dir(_temp_dir);
    proc.cached_addons(&_cached_addons);
    proc.installed_addons(&_installed_addons);
    proc.lookup_installed_addons(true);
    proc.fd(&_fd);
    proc.url_base(_url_base);
    proc.url_suffix(_url_suffix);
    proc.guid(guid);
    proc.version(version);

    proc.execute();
  }
  catch(std::exception &e)
  {
    _log->push_err(e.what());
    throw;
  }
}


void Addon_manager::install(const std::string &guid, const std::string &version)
{
  try
  {
    Addon_installer proc;
    proc.log(_log);
    proc.temp_dir(_temp_dir);
    proc.base_dir(_base_dir);
    proc.data_dir(_data_dir);
    proc.user_data_dir(_user_data_dir);
    proc.cached_addons(&_cached_addons);
    proc.installed_addons(&_installed_addons);
    proc.guid(guid);
    proc.min_ver(version); //!
    proc.max_ver(version); //!

    proc.execute();

    if (0 < proc.newly_installed_count())
      _log->push_info("Note: Some addons may require restart before usage.");
    else
      _log->push_info("Nothing to be installed.");
  }
  catch(std::exception &e)
  {
    _log->push_err(e.what());
    throw;
  }
}


void Addon_manager::uninstall(const std::string &guid)
{
  try
  {
    Addon_uninstaller proc;
    proc.log(_log);
    proc.cached_addons(&_installed_addons);
    proc.installed_addons(&_installed_addons);
    proc.guid(guid);

    proc.execute();
  }
  catch(std::exception &e)
  {
    _log->push_err(e.what());
    throw;
  }
}
