#include "stdafx.h"
#include "addon_proc.h"


Addon_proc::Addon_proc()
:
_cached_addons(NULL),
_log(Logger::default_instance())
{
}


Addon_proc::~Addon_proc()
{
}


void Addon_proc::ensure_valid_state()
{
  std::string err;

  do_ensure_valid_state(err);

  if (!err.empty())
    _log->throw_err(err);
}


void Addon_proc::do_ensure_valid_state(std::string &err)
{
  if (!_cached_addons)
    err= "Cached addons were not set.";
}


void Addon_proc::execute()
{
  ensure_valid_state();
  before_execute();
  do_execute();
  after_execute();
}
