#ifndef _WB_ADDON_MANAGER_H_
#define _WB_ADDON_MANAGER_H_


#include "wb_updater_public_interface.h"
#include "addon_manager.h"
#include "grt/grt_manager.h"
#include "grt_logger.h"


class Wb_addon_manager;
#pragma make_public(Wb_addon_manager)


class WB_UPDATER_WBP_PUBLIC_FUNC Wb_addon_manager : public Addon_manager
{
public:
  Wb_addon_manager();

  void grtm(bec::GRTManager *grtm);

  PROPERTY_I_RE(Grt_logger::Task_msg_cb, task_msg_cb, _log->task_msg_cb)
  PROPERTY_I_RE(Grt_logger::Task_progress_cb, task_progress_cb, _log->task_progress_cb)
  PROPERTY_I_RE(Grt_logger::Task_finish_cb, task_finish_cb, _log->task_finish_cb)
  PROPERTY_I_RE(Grt_logger::Task_fail_cb, task_fail_cb, _log->task_fail_cb)

  PROPERTY(std::string, active_version)
  PROPERTY(std::string, active_revision)
  PROPERTY(std::string, active_config)

  PROPERTY(std::string, directory_page_url)

  void load_manifest(const std::string &guid, const std::string &min_ver, const std::string &max_ver);
  void load_manifest_from_url(const std::string &url, std::string &guid, std::string &version);

  void start_download(const std::string &guid, const std::string &version);
  grt::ValueRef download(grt::GRT *grt, const std::string &guid, const std::string &version);
  void cancel_download();

  void get_installed_addons(std::list<std::string> &guids, std::list<std::string> &names);
  void install(const std::string &guid, const std::string &version);
  void uninstall(const std::string &guid);

private:
  bec::GRTManager *_grtm;

  Grt_logger *_log;
  Grt_logger _def_log;

  std::string _directory_page_url;

  std::string _active_version;
  std::string _active_revision;
  std::string _active_config;
};


#endif // _WB_ADDON_MANAGER_H_
