#ifndef _WB_UPDATER_H_
#define _WB_UPDATER_H_


#include "wb_updater_public_interface.h"
#include "app_updater.h"
#include "grt/grt_manager.h"


class Wb_updater;
#ifdef _WIN32
#pragma make_public(Wb_updater)
#endif

class WB_UPDATER_WBP_PUBLIC_FUNC Wb_updater : public App_updater
{
public:
  Wb_updater(bec::GRTManager *grtm);
  PROPERTY(std::string, active_revision)
  PROPERTY(std::string, active_config)
  std::string result_filepath();
  int rel_authorization(int rel_index) { return App_updater::rel_authorization(rel_index); }
  void get_rel_names(std::list<std::string> &rel_names);
  void get_mirrors(int rel_index, std::list<std::string> &mirrors);

  bool fetch_release_info();
  void start_download(int rel_index, int mirror_index);
  grt::ValueRef download(grt::GRT *grt, int rel_index, int mirror_index);
  void cancel_download();
  bool install();

  typedef sigc::slot<int, int, const std::string&> Task_msg_cb;
  typedef sigc::slot<int, float, const std::string&> Task_progress_cb;
  typedef sigc::slot<int> Task_finish_cb;
  typedef sigc::slot<int, const std::string&> Task_fail_cb;

  void task_msg_cb(Task_msg_cb cb) { _task_msg_cb= cb; }
  void task_progress_cb(Task_progress_cb cb) { _task_progress_cb= cb; }
  void task_finish_cb(Task_finish_cb cb) { _task_finish_cb= cb; }
  void task_fail_cb(Task_fail_cb cb) { _task_fail_cb= cb; }

protected:
  bec::GRTManager *_grtm;

  std::string _active_revision;
  std::string _active_config;

  float _progress_state;
  int process_download_error(long long err_no, const char *err_msg);
  int process_download_progress(double dltotal, double dlnow);

  void process_task_msg(const grt::Message &msg);
  void process_task_finish(grt::ValueRef res);
  void process_task_fail(const std::exception &error);

  Task_msg_cb _task_msg_cb;
  Task_progress_cb _task_progress_cb;
  Task_finish_cb _task_finish_cb;
  Task_fail_cb _task_fail_cb;
};


#endif // _WB_UPDATER_H_
