// mysql-backup.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <string>
#include <iostream>

static void setup_python(int argc, char **argv)
{
#ifdef _WIN32
  size_t bufsize;
  char *pathlist = NULL;
#if 0
  if (_dupenv_s(&pathlist, &bufsize, "PYTHONPATH") == 0 && pathlist)
  {
    int len = strlen("PYTHONPATH")+1+strlen(pathlist)+strlen(";python;scripts")+1;
    char *tmp = (char*)malloc(len);
    sprintf_s(tmp, len, "PYTHONPATH=%s;python;scripts", pathlist);
    _putenv(tmp);
    free(tmp);
  }
  else
#endif
    _putenv("PYTHONPATH=scripts;..\\python\\mysql_libs.zip;..\\python");
  if (pathlist) free(pathlist);
#endif
  Py_Initialize();

  PySys_SetArgv(argc, argv);
}


static void finalize_python()
{
  Py_Finalize();
}


static int import_and_call_module(const char *name)
{
  PyObject *main = PyImport_AddModule("__main__");
  PyObject *globals;
  PyObject *module = PyImport_ImportModule(name);
  int main_name_len;
  char *main_name;
  if (!main || !module)
  {
    PyErr_Print();
    fprintf(stderr, "Unable to start %s, please verify that your installation is correct\n",
      name);
    return -1;
  }

return 0;

  globals = PyModule_GetDict(main);
  if (!globals)
  {
    PyErr_Print();
    fprintf(stderr, "Unable to start %s, please verify that your installation is correct\n",
      name);
    return -1;
  }

  PyDict_SetItemString(globals, name, module);

  main_name_len = strlen(name)+strlen("_main()")+2;
  main_name = (char*)malloc(main_name_len);
  if (!main_name)
  {
    fprintf(stderr, "Out of memory\n");
    return -1;
  }

#ifdef _WIN32
  sprintf_s(main_name, main_name_len, "%s._main()", name);
#else
  snprintf(main_name, main_name_len, "%s._main()", name);
#endif
  // call the _main() function from the module
  PyObject *result = PyRun_String(main_name, Py_eval_input, globals, globals);
  if (!result)
  {
    free(main_name);
    PyErr_Print();
    fprintf(stderr, "Error executing %s, please verify that your installation is correct\n",
      name);
    return -1;
  }

  free(main_name);

  // result is the return code
  return (int)PyInt_AsLong(result);
}



int main(int argc, char* argv[])
{
  int rc;

#ifdef _WIN32
  // not working
  //SetDllDirectoryA("dll");
#endif

  setup_python(argc, argv);

  std::string filepath(argv[0]);
  size_t name_start = filepath.find_last_of('\\');
  if (name_start == std::string::npos)
    name_start = 0;
  else
    ++name_start;
  size_t name_end = filepath.find_last_of('.');
  size_t name_size = name_end - name_start;
  if (name_size < 0)
    name_size = std::string::npos;
  std::string filename = filepath.substr(name_start,name_size);
  //filename.append(".py");
  //std::cout<<filename<<std::endl;
  rc = import_and_call_module(filename.c_str());
  
  finalize_python();

  return rc;
}

