#ifndef _DB_SQL_EDITOR_LOG_BE_H_
#define _DB_SQL_EDITOR_LOG_BE_H_


#include "workbench/wb_backend_public_interface.h"
#include "sqlide/var_grid_model_be.h"
#include <boost/shared_ptr.hpp>


class MYSQLWBBACKEND_PUBLIC_FUNC DbSqlEditorLog : public VarGridModel
{
public:
  typedef boost::shared_ptr<DbSqlEditorLog> Ref;
  static Ref create(bec::GRTManager *grtm) { return Ref(new DbSqlEditorLog(grtm)); }
  virtual ~DbSqlEditorLog() {}
protected:
  DbSqlEditorLog(bec::GRTManager *grtm);

public:
  virtual void reset();

public:
  virtual bec::IconId get_field_icon(const bec::NodeId &node, int column, bec::IconSize size);

public:
  RowId add_message(int msg_type, const std::string &context, const std::string &msg, const std::string &duration);
  void set_message(RowId row, int msg_type, const std::string &context, const std::string &msg, const std::string &duration);
};


#endif /* _DB_SQL_EDITOR_LOG_BE_H_ */
