
#ifndef _WB_LIVE_SCHEMA_TREE_H_
#define _WB_LIVE_SCHEMA_TREE_H_

#include "grt/tree_model.h"
#include "grtpp.h"

namespace wb
{
  class LiveSchemaTree : public bec::TreeModel
  {
  public:
    enum ObjectType
    {
      Schema,
      Table,
      View,
      Routine
    };

    struct ColumnNode
    {
      ColumnNode() : is_pk(false), is_fk(false) {}
      std::string name;
      bool is_pk;
      bool is_fk;
    };
    
    struct ObjectNode
    {
      ObjectNode() : fetched(false), fetching(false) {}
      std::string name;
      std::string details;
      std::vector<ColumnNode> columns;
      bool fetched;
      bool fetching;
      bool operator <(const ObjectNode &node) const { return name < node.name; }
    };
    
    struct SchemaNode
    {
      std::string name;
      std::vector<ObjectNode> tables;
      std::vector<ObjectNode> views;
      std::vector<ObjectNode> routines;
      bool fetched;
      bool fetching;
    };
    
    typedef sigc::signal<void> RefreshSlot;
    typedef sigc::slot<void, SchemaNode> SchemaContentArrivedSlot;
    typedef sigc::slot<void, SchemaNode, ObjectNode, ObjectType> ObjectDetailsArrivedSlot;
    typedef sigc::slot<std::list<std::string> > SchemaListFetchSlot;
    typedef sigc::slot<bool, bec::NodeId, std::string, SchemaContentArrivedSlot> SchemaFetchSlot;
    typedef sigc::slot<bool, ObjectType, std::string, std::string, ObjectDetailsArrivedSlot> ObjectDetailsFetchSlot;
    typedef sigc::signal<void, std::string, ObjectType, std::string, std::string> LiveObjectActionSignal;
    typedef sigc::signal<void, ObjectType, std::string, std::string> LiveObjectSignal;
    typedef sigc::signal<int, const std::string&> SqlEditorTextInsertSignal;
    typedef sigc::slot<bec::MenuItemList, std::string, std::string, std::string> ObjectPluginMenuItemsSlot;
    typedef sigc::slot<bool, std::string, std::string, std::string, std::string> CallObjectPluginMenuItemsSlot;

    RefreshSlot pre_refresh_signal;  // Used only with gtk to workaround problem with refresh   //XXX maybe unnecessary
    RefreshSlot refresh_signal; //XXX maybe unnecessary
    sigc::signal<void, const std::string&> active_schema_change_signal;
    SchemaListFetchSlot list_fetch_slot;
    SchemaFetchSlot fetch_slot;
    ObjectDetailsFetchSlot details_fetch_slot;
    LiveObjectActionSignal activate_object_signal;
    LiveObjectSignal alter_live_object_signal;
    LiveObjectSignal create_live_object_signal;
    LiveObjectSignal drop_live_object_signal;
    SqlEditorTextInsertSignal sql_editor_text_insert_signal;
    ObjectPluginMenuItemsSlot object_plugin_items_slot;
    CallObjectPluginMenuItemsSlot call_object_plugin_items_slot;

  protected:
    grt::GRT* _grt;
    std::vector<SchemaNode> _schemata;
    std::string _active_schema;
    int _schemata_vector_serial;
    bool _rebuilding;

    void schema_contents_arrived(const SchemaNode &node, int index, int serial);
    void object_details_arrived(const SchemaNode &schema_node, const ObjectNode &obj_node, ObjectType obj_type, int schema_index, int obj_index, int serial);
    ObjectNode * load_object_details(const bec::NodeId &index_node);

  public:
    LiveSchemaTree(grt::GRT* grtm);

    std::vector<ObjectNode> * get_object_nodes_by_index(const bec::NodeId &index_node, ObjectType *object_type= NULL);
    ObjectNode * get_object_node_by_index(const bec::NodeId &index_node, ObjectType *object_type= NULL);
    std::vector<ObjectNode> * get_object_nodes_by_type(SchemaNode *schema_node, ObjectType obj_type);

    void set_active_schema(const std::string &schema);
    int get_index_of_schema(const std::string &schema_name) const;

    virtual bool is_expandable(const bec::NodeId &node);
    virtual bool expand_node(const bec::NodeId &node);

    virtual void refresh();
    virtual void refresh_ex(bool hard_refresh);
    virtual void refresh_ex(const std::list<std::string> &schema_list, bool hard_refresh);
    virtual int count_children(const bec::NodeId &node);
    virtual bec::NodeId get_child(const bec::NodeId &node, int index);
    
    void update_live_object_state(ObjectType type, const std::string &schema_name, const std::string &old_obj_name, const std::string &new_obj_name);

    virtual std::string get_field_description(const bec::NodeId &node, int column);
    virtual bool get_field(const bec::NodeId &node, int column, std::string &value);
    virtual bool get_field(const bec::NodeId &node, int column, int &value);
    virtual bec::IconId get_field_icon(const bec::NodeId &node, int column, bec::IconSize size);
    
    bec::NodeId get_node_for_schema(const std::string &name);
    
    virtual bool activate_node(const bec::NodeId &node);
    
    virtual bool activate_popup_item_for_nodes(const std::string &name, const std::vector<bec::NodeId> &orig_nodes);
    virtual bec::MenuItemList get_popup_items_for_nodes(const std::vector<bec::NodeId> &nodes);

    bool is_schema_contents_enabled() const;
    void is_schema_contents_enabled(bool value);

    virtual bool is_highlighted(const bec::NodeId& node);
  private:
    bool _is_schema_contents_enabled;
  };
};

#endif
