/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WB_COMMAND_UI_H_
#define _WB_COMMAND_UI_H_


#include "wb_context.h"

namespace mforms
{
  class MenuBar;
  class MenuItem;
  class ToolBar;
  class ToolBarItem;
};

namespace wb
{
  struct ParsedCommand;

  // Manager menus and toolbars.
  class MYSQLWBBACKEND_PUBLIC_FUNC CommandUI
  {
    friend class WBContextUI;
    
    struct BuiltinCommand
    {
      sigc::slot<void> execute;
      sigc::slot<bool> validate;
    };

    WBContext *_wb;
    // dynamic UI stuff
    grt::ListRef<app_ShortcutItem> _shortcuts;

    std::map<std::string, BuiltinCommand> _builtin_commands;
    sigc::signal<void> _validate_edit_menu_items;

    bool validate_command_item(const app_CommandItemRef &item, const ParsedCommand &cmd);
    void update_item_state(const app_ToolbarItemRef &item, const ParsedCommand &cmd, mforms::ToolBarItem *tb_item);
    void update_item_state(const app_CommandItemRef &item, const ParsedCommand &cmd, mforms::MenuItem *menu_item);

    void append_shortcut_items(const grt::ListRef<app_ShortcutItem> &plist, const std::string &context,
      std::vector<WBShortcut> *items);

    bool execute_builtin_command(const std::string &name);
    bool validate_builtin_command(const std::string &name);
    bool validate_plugin_command(const std::string &name);
    
  private:
    void add_recent_menu(mforms::MenuItem *parent);
    void add_plugins_menu_items(mforms::MenuItem *parent, const std::string &group);
    void add_plugins_menu(mforms::MenuItem *parent, const std::string &context);
    void add_menu_items_for_context(const std::string &context, mforms::MenuItem *parent, const app_MenuItemRef &menu);    
  public:
    mforms::MenuBar *create_menubar_for_context(const std::string &context);
    
    sigc::signal<void> &signal_validate_edit_menu_items() { return _validate_edit_menu_items; }
  public:
    CommandUI(WBContext *wb);

    mforms::ToolBar *create_toolbar(const std::string &toolbar_file);
    mforms::ToolBar *create_toolbar(const std::string &toolbar_file, const sigc::slot<void, std::string> &activate_slot);
    
    void load_data();

    void activate_command(const std::string &command);
    bool activate_command(const std::string &command, bec::ArgumentPool argpool);
    
    std::vector<WBShortcut> get_shortcuts_for_context(const std::string &context);

    void add_frontend_commands(const std::list<std::string> &commands);
    void add_builtin_command(const std::string &name, 
                             const sigc::slot<void> &slot,
                             const sigc::slot<bool> &validate= sigc::slot<bool>());
    void remove_builtin_command(const std::string &name);    
  };
};


#endif /* _WB_COMMAND_UI_H_ */
