#include "stdafx.h"

#include "test.h"
#include "grt/grt_dispatcher.h"
#include "grt/grt_manager.h"

using namespace grt;
using namespace bec;



BEGIN_TEST_DATA_CLASS(be_grt_dispatcher)
public:
  GRTManager grtm;

TEST_DATA_CONSTRUCTOR(be_grt_dispatcher)
: grtm(true)
{
  grtm.initialize();
}

END_TEST_DATA_CLASS;


TEST_MODULE(be_grt_dispatcher, "grt request dispatcher");


static void finished(grt::ValueRef result, bool *flag)
{
  *flag= true;
}


static void finished_with_wait(grt::ValueRef result, bool *flag)
{
  g_usleep(2000000);
  *flag= true;
}


static grt::ValueRef normal_test_function(grt::GRT *grt)
{
  return grt::IntegerRef(123);
}


TEST_FUNCTION(2)
{
  // test callbacks
  GRTTask *task;

  grt::ValueRef result;
  bool finish_called= false;
  
  task= new GRTTask("test", grtm.get_dispatcher(), sigc::ptr_fun(normal_test_function));
  task->signal_finished().connect(sigc::bind<bool*>(sigc::ptr_fun(finished), &finish_called));
  
  result= grtm.get_dispatcher()->add_task_and_wait(task);
  
  ensure("result", result.is_valid() && result.type() == grt::IntegerType);
  ensure_equals("result value", *grt::IntegerRef::cast_from(result), 123);

  ensure("finish callback called", finish_called);
  
  
  finish_called= false;
  task= new GRTTask("test", grtm.get_dispatcher(), sigc::ptr_fun(normal_test_function));
  task->signal_finished().connect(sigc::bind<bool*>(sigc::ptr_fun(finished_with_wait), &finish_called));
  
  result= grtm.get_dispatcher()->add_task_and_wait(task);
  
  ensure("finish callback called with wait", finish_called);
}


TEST_FUNCTION(5)
{
  // test msg queue

  

}


TEST_FUNCTION(6)
{
  // test task calling another task

}


END_TESTS

