/*
 *  grtdb_connect_dialog.h
 *  MySQLWorkbench
 *
 *  Created by Alfredo Kojima on 2/May/09.
 *  Copyright 2009 Sun Microsystems Inc. All rights reserved.
 *
 */

#ifndef _GRTDBCONNECTIONDIALOG_H_
#define _GRTDBCONNECTIONDIALOG_H_

#include "wb_config.h"

#include <mforms/mforms.h>

#include "db_conn_be.h"
#include "grtdb_connect_panel.h"
#include "grt/grt_manager.h"

namespace grtui
{
  
  class WBPUBLICBACKEND_PUBLIC_FUNC DbConnectionDialog : public mforms::Form
  {
  public:
    DbConnectionDialog(const db_mgmt_ManagementRef &mgmt);
    
    db_mgmt_ConnectionRef run();
    
  protected:
    db_mgmt_ManagementRef _mgmt;
    DbConnectPanel _panel;
    
    mforms::Box _top_vbox;
        
    mforms::Box _bottom_hbox;
    mforms::Button _ok_button;
    mforms::Button _cancel_button;
    mforms::Button _test_button;
    
    //! Called from selector/list of connections to tell that things changed
    void change_active_stored_conn();
    
  private:
    void ok_clicked();
    void cancel_clicked();
    void test_clicked();
    
    void reset_stored_conn_list();
  };
  
};

#endif /* _GRTDBCONNECTIONDIALOG_H_ */
