/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef __GRT_MODULES_TREE_H__
#define __GRT_MODULES_TREE_H__

namespace MySQL {
  namespace Grt {

    public ref class GrtModulesTree : public TreeModel
    {
    public:
      enum class Columns {
        Name = ::bec::ModulesTreeBE::Name
      };

      GrtModulesTree(GRT^ grt)
        : TreeModel(new ::bec::ModulesTreeBE(grt->get_unmanaged_object()))
      {}

      GrtModulesTree(::bec::ModulesTreeBE *inn)
        : TreeModel(inn)
      {}

      inline ::bec::ModulesTreeBE *get_unmanaged_object()
      { return static_cast<::bec::ModulesTreeBE *>(inner); }

      //virtual int count_children(const NodeId &parent);
      //virtual NodeId get_child(const NodeId &parent, int index);

      //virtual bool get_field(const NodeId &node, int column, std::string &value);

      //virtual void refresh();
    };


  } // namespace Grt
} // namespace MySQL

#endif // __GRT_MODULES_TREE_H__