/* 
 * Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _EDIT_SQL_SCRIPT_WIZARD_H_
#define _EDIT_SQL_SCRIPT_WIZARD_H_

#include "grt/common.h"
#include "grtui/grt_wizard_form.h"
#include "grtui/connection_page.h"
#include "wb_context.h"
#include "mforms/fs_object_selector.h"

/**
 * Implementation of a wizard to edit SQL script.
 */

using namespace grtui;
using namespace mforms;

class SqlScriptSelectionPage : public WizardPage
{
public:
  SqlScriptSelectionPage(WizardForm* host);

protected:
  void file_changed();
  virtual void do_validate();
  virtual bool allow_next();
  virtual bool advance();
  virtual std::string next_button_caption();

private:
  Table _table;
  FsObjectSelector _file_selector;
  Label _caption;
  Label _file_selector_heading;
  Label _options_selector_heading;
  CheckBox _autorun_check;

private:
  DbConnection *_db_conn;
  wb::WBContext* _context;
public:
  void set_db_connection(DbConnection *value);
  void set_context(wb::WBContext* context);
};

class EditSqlScriptWizard : public WizardForm
{
public:
  EditSqlScriptWizard(wb::WBContext* context);
  ~EditSqlScriptWizard();

private:
  SqlScriptSelectionPage* _sql_script_selection_page;
  ConnectionPage* _db_conn_page;
private:
  DbConnection _db_conn;
  wb::WBContext* _context;
};

#endif // _EDIT_SQL_SCRIPT_WIZARD_H_
