/*
 *  user_defined_type_editor.h
 *  MySQLWorkbench
 *
 *  Created by Alfredo Kojima on 16/Mar/09.
 *  Copyright 2009 Sun Microsystems Inc. All rights reserved.
 *
 */

#ifndef _USER_DEFINED_TYPE_EDITOR_H_
#define _USER_DEFINED_TYPE_EDITOR_H_


#include <mforms/mforms.h>

#include "workbench/wb_context_ui.h"
#include "workbench/wb_backend_public_interface.h"
#include "grts/structs.workbench.physical.h"

class MYSQLWBBACKEND_PUBLIC_FUNC UserDefinedTypeEditor : public mforms::Form 
{ 
  wb::WBContextUI *_wbui;
  workbench_physical_ModelRef _model;

  mforms::Box _vbox;
  mforms::TreeView _type_list;
  
  mforms::Table _table;
  mforms::Label _namel;
  mforms::TextEntry _name;
  mforms::Label _typel;
  mforms::Selector _type;
  mforms::Label _argsl;
  mforms::Box _args_box;
  mforms::TextEntry _args;
  mforms::Button _args_edit;
  mforms::Label _flagsl;
  mforms::Box _flags_box;
  
  mforms::Box _button_box;
  mforms::Button _add_button;
  mforms::Button _delete_button;
  
  mforms::Button _apply_button;
  mforms::Button _close_button;

  std::vector<mforms::CheckBox*> _flags;
  std::vector<db_UserDatatypeRef> _user_types;

  bool check_if_type_used(const db_UserDatatypeRef &type);
  
  void add_clicked();
  void delete_clicked();
  void apply_clicked();
  void close_clicked();
  void edit_arguments();
  
  void name_changed();
  void args_changed();
  void type_changed();
  void flag_toggled();
  void refresh();
  void selected_row();
public:
  UserDefinedTypeEditor(wb::WBContextUI *wbui, const workbench_physical_ModelRef &model);
};


#endif /* _USER_DEFINED_TYPE_EDITOR_H_ */
