//!
//! \addtogroup linuxui Linux UI
//! @{
//! 

#ifndef _CATALOG_TREE_H_
#define _CATALOG_TREE_H_

#include <gtkmm/scrolledwindow.h>
#include <gtkmm/treeview.h>
#include "treemodel_wrapper.h"
#include "workbench/wb_context_ui.h"

class CatalogTree : public Gtk::ScrolledWindow
{
  wb::WBContextUI *_wbui;
  Gtk::TreeView _tree;
  Glib::RefPtr<TreeModelWrapper> _model;
  ExpandedRowsStorage            _expanded_rows;

  bool reexpand_node(const Gtk::TreePath &path);
  void reexpand_nodes();

  void tree_changed(const bec::NodeId &node, int old_count);

  void drag_begin(const Glib::RefPtr<Gdk::DragContext> &context);
  void drag_data_get(const Glib::RefPtr<Gdk::DragContext> &context,
                     Gtk::SelectionData &data, guint , guint);

  void handle_menu(const std::string&, const std::vector<bec::NodeId>&);

public:
  CatalogTree(wb::WBContextUI *wbui);

  void refresh();
};


#endif /* _CATALOG_TREE_H_ */

//!                                                                                                                                     
//! @}                                                                                                                                  
//!
