
#include "model_panel.h"
#include "overview_panel.h"
#include "linux_utilities/MGGladeXML.h"
#include "linux_utilities/gtk_helpers.h"
#include <gtkmm/alignment.h>
#include <gtkmm/notebook.h>
#include <gtk/gtkhpaned.h>
#include "mforms/../gtk/lf_toolbar.h"
#include "mforms/../gtk/lf_menubar.h"
#include "user_types_box.h"
#include "history_tree.h"
#include "documentation_box.h"

#define _(s) s

bool ModelPanel::will_close()
{ 
  _overview->will_close(); 
  return false;
}


ModelPanel *ModelPanel::create(wb::WBContextUI *wb, wb::OverviewBE *overview)
{
  MGGladeXML *xml= new MGGladeXML(wb->get_wb()->get_grt_manager()->get_data_file_path("model_view.glade").c_str(), "", "");
  GtkHPaned *paned;

  paned = GTK_HPANED(xml->get_unwrapped("model_pane"));
  
  ModelPanel *panel = new ModelPanel(xml, paned, wb, overview);

  delete xml;
  
  return panel;
}


static void fix_size(Gtk::Paned *paned)
{
  int pos = paned->get_position();
  paned->set_position(paned->get_parent()->get_width() - paned->get_position());
}

ModelPanel::ModelPanel(MGGladeXML *xml, GtkHPaned *paned, wb::WBContextUI *wb, wb::OverviewBE *overview)
  : Gtk::HPaned(paned), _wb(wb)
{
  _top_box = new Gtk::VBox(false, 0);
  {
    mforms::MenuBar *menubar = overview->get_menubar();
    if (menubar)
      _top_box->pack_start(*mforms::gtk::widget_for_menubar(menubar), false, true);
    mforms::ToolBar *toolbar = overview->get_toolbar();
    if (toolbar)
      _top_box->pack_start(*mforms::gtk::widget_for_toolbar(toolbar), false, true);
  }
  _top_box->show_all();
  _top_box->pack_start(*this, true, true);
  show();

  if (wb->get_wb()->get_wb_options().get_int("Sidebar:RightAligned", 0))
  {
    swap_panned_children(this, true);
    signal_realize().connect(sigc::bind(sigc::ptr_fun(fix_size), this));
  }

  _overview = new OverviewPanel(wb, overview);
  
  xml->get("editor_tab", &_editor_note);
  xml->get("content", &_editor_paned);
  
  xml->get("model_sidebar", &_sidebar);
  
  Gtk::Alignment *placeholder;
  
  xml->get("overview_placeholder", &placeholder);
  
  placeholder->add(*_overview);
  _overview->show();
  
  Gtk::Notebook *note;
  Gtk::Label *label;

  xml->get("side_model_note0", &note);
  _documentation_box= Gtk::manage(new DocumentationBox(wb));
  label = Gtk::manage(new Gtk::Label(_("<small>Description</small>")));
  note->append_page(*_documentation_box, *label);
  label->set_use_markup(true);

  xml->get("side_model_note1", &note);
  _usertypes_box= Gtk::manage(new UserTypesBox(wb));
  label = Gtk::manage(new Gtk::Label(_("<small>User Types</small>")));
  note->append_page(*_usertypes_box, *label);
  label->set_use_markup(true);

  _history_tree= Gtk::manage(new HistoryTree(wb));
  label = Gtk::manage(new Gtk::Label(_("<small>History</small>")));
  note->append_page(*_history_tree, *label);
  label->set_use_markup(true);

}


void ModelPanel::selection_changed()
{
  _documentation_box->update_for_form(_overview->get_be());
}


std::string ModelPanel::get_title()
{
  return "Model";
}


bec::UIForm *ModelPanel::get_form() const
{
  return (bec::UIForm*)_overview->get_be();
}


ModelPanel::~ModelPanel()
{
  delete _overview;
  delete _top_box;
}


void ModelPanel::toggle_sidebar()
{
  if (_sidebar->is_visible())
    _sidebar->hide();
  else
    _sidebar->show();
}


void ModelPanel::find_text(const std::string &text)
{
  _last_found_node = _overview->get_be()->search_child_item_node_matching(bec::NodeId()
                                                                          , _last_found_node
                                                                          ,text
                                                                          );

  if (_last_found_node.is_valid())
  {
    get_overview()->select_node(_last_found_node);
  }
}
