#ifndef __DB_SQL_EDITOR_VIEW_H__
#define __DB_SQL_EDITOR_VIEW_H__

#include "linux_utilities/MGGladeXML.h"
#include "sqlide/wb_sql_editor_form.h"
#include "sqlide/sql_editor_fe.h"
#include "sqlide/recordset_view.h"
#include "linux_utilities/form_view_base.h"
#include "overview_panel.h"

class SqlSnippetsView;
class ToolbarManager;

class DbSqlEditorView : public Gtk::VBox, public FormViewBase
{
  DbSqlEditorView(Db_sql_editor::Ref editor_be, GtkVBox *vbox, MGGladeXML *xml);
public:
  static DbSqlEditorView *create(Db_sql_editor::Ref editor_be);
  virtual ~DbSqlEditorView();

  virtual void init();
  virtual bool will_close();

  virtual bec::BaseEditor* get_be() { return NULL; }
  virtual std::string get_title() { return _be->caption(); }
  virtual bec::UIForm *get_form() const { return _be.get(); }
  virtual Gtk::Widget *get_panel() { return this; }
  virtual void toggle_sidebar();
  virtual void find_text(const std::string &text);

private:
  bool toolbar_action(const std::string& it);
  bool output_toolbar_action(const std::string& it) {return false;}

  Glib::Dispatcher _dispatch_rset_update;
  Db_sql_editor::Ref _be;
  MGGladeXML *_xml;
  std::vector<boost::shared_ptr<SqlEditorFE> > _sql_editors;
  Gtk::Container *_view;
  Gtk::Notebook *_tab_pages;
  Gtk::Container *_log_page;
  Gtk::Label *_log_event_detail_header_label;
  Gtk::TextView *_log_event_detail_action_text_view;
  Gtk::TextView *_log_event_detail_message_text_view;
  GridView *_log_view;
  GridView *_history_entries_view;
  GridView *_history_details_view;
  Gtk::Menu *_history_details_popup_menu;
  Gtk::Notebook *_output_note;
  Gtk::RadioButton *_output_text_radio;
  Gtk::TextView *_output_text;
  SqlSnippetsView *_sql_snippets_view;
  bool _closing;

  SqlEditorFE *active_editor();
  RecordsetView *active_recordset();
private:
  OverviewPanel *_live_physical_overview;
public:
  OverviewPanel * live_physical_overview() { return _live_physical_overview; }

  void add_editor_tab();
private:
  typedef std::map<Recordset::Ref, RecordsetView*> Recordset2View;
  typedef std::map<RecordsetView*, Recordset::Ref> View2Recordset;
  Recordset2View _recordset2view;
  View2Recordset _view2recordset;
  int close_recordset(long long key, bool confirm = false);
  void recordset_list_changed(Recordset::Ref rset, bool added);

  void close_editor_tab(boost::shared_ptr<SqlEditorFE> editor);
  void update_resultsets();
  void clear_output();
private:
  std::string _sql_script_filepath;

public:
  void execute_sql_script(bool current_statement_only);

  RecordsetView *get_active_recordset();

public:
  bool validate_explain_sql();
  void explain_sql();

private:
  int after_exec_sql_finished();
  int on_exec_sql_progress(float progress, const std::string &message);

  bool on_sql_editor_key_press_event(GdkEventKey *event);
  void on_sql_editor_selection_change();

  void refresh_log_view();
  void on_log_view_selection_changed();

  void on_history_entries_selection_changed();
  sigc::slot<void> _on_history_entries_selection_changed_cb;
  int on_history_entries_refresh();
  bool on_history_entries_view_event(GdkEvent *event);
  bool on_history_details_view_event(GdkEvent *event);
  void load_selected_history_items(bool overwrite);
  void on_append_to_sql_script_menuitem_activate();
  void on_replace_sql_script_menuitem_activate();

  void editor_page_switched(GtkNotebookPage *page, guint);
  void lower_page_switched(GtkNotebookPage *page, guint);
  
  void editor_caption_changed();
  void recordset_caption_changed();

  void refresh_ui(const int what);
  
  void output_text(const std::string &text, bool bring_to_front);

  int on_sql_editor_text_insert(const std::string &text);
};


#endif // __DB_SQL_EDITOR_VIEW_H__
