//
//  WBMiniToolbar.m
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 5/May/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import "WBMiniToolbar.h"
#import "NSColor_extras.h"

@implementation WBMiniToolbar

- (id)initWithFrame:(NSRect)frame 
{
  self = [super initWithFrame:frame];
  if (self)
  {
    mOptionInfoList= [[NSMutableArray array] retain];
  }
  return self;
}


- (void) dealloc
{
  [mOptionInfoList release];
  [super dealloc];
}


- (void)resizeSubviewsWithOldSize:(NSSize)osize
{
  [self tile];
  [super resizeSubviewsWithOldSize: osize];
}


- (void)drawRect:(NSRect)rect 
{
  NSGradient *gradient= 
  [[NSGradient alloc] initWithStartingColor:[NSColor colorWithCalibratedRed:247/256.0 green:247/256.0 blue:247/256.0 alpha:1.0]
                                endingColor:[NSColor colorWithCalibratedRed:222/256.0 green:222/256.0 blue:222/256.0 alpha:1.0]];
  
  [gradient drawInRect:[self bounds] angle: 270];
  [gradient release];
}


- (void)removeAllItems
{
  for (id view in [[self subviews] reverseObjectEnumerator])
    [view removeFromSuperview];
}


- (void)setDelegate:(id)delegate
{
  mDelegate= delegate;
}


- (void)colorPopupChanged:(id)sender
{
  id info= [mOptionInfoList objectAtIndex: [sender tag]];
  
  [mDelegate miniToolbar: self
            popupChanged: [info objectForKey: @"name"]
                  option: [info objectForKey: @"option"]
                   value: [[sender selectedItem] representedObject]];
}


- (void)popupChanged:(id)sender
{
  id info= [mOptionInfoList objectAtIndex: [sender tag]];
  
  [mDelegate miniToolbar: self
            popupChanged: [info objectForKey: @"name"]
                  option: [info objectForKey: @"option"]
                   value: [sender titleOfSelectedItem]];
}


- (void)tile
{
  float height= NSHeight([self frame]);
  float x= 5;
  float fixedWidth = 0;
  int expanderCount = 0;

  for (id item in [self subviews])
  {
    if ([item class] == [NSView class] && NSHeight([item frame]) == 0)
      expanderCount++;
    else
      fixedWidth += NSWidth([item frame]);
  }
  fixedWidth += 8 * ([[self subviews] count]-1);

  for (id item in [self subviews])
  {
    NSRect frame= [item frame];
    frame.origin.x= x;
    frame.origin.y= (height - NSHeight(frame)) / 2;
    if ([item class] == [NSView class] && NSHeight([item frame]) == 0)
    {
      frame.size.width = (NSWidth([self frame]) - 10 - fixedWidth) / expanderCount;
    }   
    [item setFrame: frame];
    x+= NSWidth(frame);
    x+= 8;
  }
}


- (NSButton*)addButtonWithTitle:(NSString*)title
                         target:(id)target
                         action:(SEL)action
                            tag:(int)tag
{
  NSButton *button= [[[NSButton alloc] initWithFrame: NSMakeRect(0, 0, 10, 10)] autorelease];
  
  [button setButtonType: NSMomentaryLightButton];
  [button setTitle: title];
  [button setTag: tag];
  [button setTarget: target];
  [button setAction: action];
  [button setBordered: YES];

  [button setBezelStyle: NSRoundedBezelStyle];
  
  [self addSubview: button];
  
  [button sizeToFit];
  [self tile];
  
  return button;
}

- (NSButton*)addButtonWithIcon:(NSImage*)icon
                        target:(id)target
                        action:(SEL)action
                           tag:(int)tag
{
  NSButton *button= [[[NSButton alloc] initWithFrame: NSMakeRect(0, 0, 18, 18)] autorelease];
  
  [button setButtonType: NSMomentaryLightButton];
  [button setBordered: NO];
  [button setImagePosition: NSImageOnly];
  [button setImage: icon];
  [button setTag: tag];
  [button setTarget: target];
  [button setAction: action];
  [button setBordered: NO];
  
  //[button setBezelStyle: NSRoundedBezelStyle];
  
  [self addSubview: button];
  
//  [button sizeToFit];
  [self tile];
  
  return button;
}

- (NSTextField*)addLabelWithTitle:(NSString*)title
{
  NSTextField *label= [[[NSTextField alloc] initWithFrame: NSMakeRect(0, 0, 10, 10)] autorelease];
  
  [label setStringValue: title];
  [label setEditable: NO];
  [label setDrawsBackground: NO];
  [label setBordered: NO];
  [label setFont: [NSFont systemFontOfSize: [NSFont smallSystemFontSize]]];
  
  [self addSubview: label];
  [label sizeToFit];
  [self tile];
  
  return label;
}

- (void)addExpandingSpace
{
  NSView *view = [[NSView alloc] initWithFrame:NSMakeRect(0, 0, 0, 0)];
  [self addSubview: view];
  [view release];
  [view setHidden: YES];
}

- (void)addSeparator
{
  NSBox *box= [[[NSBox alloc] initWithFrame: NSMakeRect(0, 2, 1, 18)] autorelease];
  [box setTitlePosition: NSNoTitle];
  [box setBoxType: NSBoxSeparator];
  [self addSubview: box];

  [self tile];
}

- (NSPopUpButton*)addSelectionPopUpWithItems:(NSArray*)items
                            target:(id)target
                            action:(SEL)action
                      defaultValue: (NSString*)defaultValue
{
  NSPopUpButton *popup= [[[NSPopUpButton alloc] initWithFrame: NSMakeRect(0, 0, 10, 10)] autorelease];
  for (NSString *title in items)
  {
    if ([title length] == 0)
      [[popup menu] addItem: [NSMenuItem separatorItem]];
    else
      [popup addItemWithTitle: title];
  }
  [popup setTarget: target];
  [popup setAction: action];
  [[popup cell] setControlSize: NSSmallControlSize];
  [popup setFont: [NSFont systemFontOfSize: [NSFont smallSystemFontSize]]];
  [popup sizeToFit];
  [popup setBordered: NO];
  [self addSubview: popup];
  
  if (!defaultValue)
    [popup selectItemAtIndex: 0];
  else
    [popup selectItemWithTitle: defaultValue];
  
  [self tile];
  
  return popup;
}


- (NSPopUpButton*)addSelectionPopUpWithItems:(NSArray*)items
                              name: (NSString*)name
                            option: (NSString*)option
                      defaultValue: (NSString*)defaultValue
{
  NSPopUpButton *popup = [self addSelectionPopUpWithItems: items
                            target: self
                            action: @selector(popupChanged:) 
                      defaultValue: defaultValue];
  
  [popup setTag: [mOptionInfoList count]];  
    
  [mOptionInfoList addObject: [NSDictionary dictionaryWithObjectsAndKeys: 
                               name, @"name", 
                               option, @"option", nil]];
  
  return popup;
}

- (void)addSelectionPopUpWithColors:(NSArray*)colors
                               name: (NSString*)name
                             option: (NSString*)option
                       defaultValue: (NSString*)defaultValue
{
  NSPopUpButton *popup= [[[NSPopUpButton alloc] initWithFrame: NSMakeRect(0, 0, 10, 10)] autorelease];
  NSMenu *menu= [[NSMenu alloc] initWithTitle: @""];
  NSMenuItem *selected= nil;
  [[popup cell] setControlSize: NSSmallControlSize];
  for (NSColor *color in colors)
  {
    NSMenuItem *item= [[NSMenuItem alloc] init];
    NSImage *image= [[NSImage alloc] initWithSize: NSMakeSize(24, 16)];
    [image lockFocus];
    [[NSColor lightGrayColor] set];
    NSFrameRect(NSMakeRect(1, 1, 22, 14));
    [color set];
    NSRectFill(NSMakeRect(2, 2, 20, 12));
    [image unlockFocus];
    [item setImage: image];
    [item setTitle: @""];
    [item setRepresentedObject: [color hexString]];
    [image release];
    [menu addItem: item];
    [item release];
    
    if ([defaultValue isEqual: [item representedObject]])
      selected= item;
  }
  [popup setMenu: menu];
  
  if (selected)
    [popup selectItem: selected];
  
  [popup setBordered: NO];
  [popup setTarget: self];
  [popup setAction: @selector(colorPopupChanged:)];
  [popup sizeToFit];
  { // fix the extra unneeded padding we get for some reason
    NSRect frame= [popup frame];
    frame.size.width-= 24;
    [popup setFrame: frame];
  }
  [self addSubview: popup];
  
  [popup setTag: [mOptionInfoList count]];
  [mOptionInfoList addObject: [NSDictionary dictionaryWithObjectsAndKeys: name, @"name", option, @"option", nil]];

  [self tile];
}

@end
