/*!
 Copyright 2009 Sun Microsystems, Inc.
 */ 



#import "WBSplitView.h"



@implementation WBSplitView


- (void)setDividerThickness:(float)f
{
  mDividerThickness= f;
}


- (CGFloat) dividerThickness;
{
	return mDividerThickness;
	
  /*if ([self isVertical])
    return mDividerThickness;
  else
    return [super dividerThickness];*/
}



- (void) drawDividerInRect: (NSRect) aRect;
{
  NSColor* color;
  
  if (mEnabled) {
    color = [NSColor colorWithCalibratedRed: 0.42
                                      green: 0.42
                                       blue: 0.42
                                      alpha: 1];
  }
  else {
    color = [NSColor colorWithCalibratedRed: 0.8
                                      green: 0.8
                                       blue: 0.8
                                      alpha: 1];
  }
  
  [color set];
  [NSBezierPath fillRect: aRect];
}



- (void) handleDidBecomeMain: (id) aNotification;
{
  mEnabled = YES;
  [self setNeedsDisplay: YES];
}



- (void) handleDidResignMain: (id) aNotification;
{
  mEnabled = NO;
  [self setNeedsDisplay: YES];
}



#pragma mark Create and Destroy



- (void) awakeFromNib;
{
  mEnabled = YES;
  mDividerThickness = 1;
  
  // Set up notifications.
  NSNotificationCenter* dc = [NSNotificationCenter defaultCenter];
  [dc addObserver: self
         selector: @selector(handleDidBecomeMain:)
             name: NSWindowDidBecomeMainNotification
           object: [self window]];
  [dc addObserver: self
         selector: @selector(handleDidResignMain:)
             name: NSWindowDidResignMainNotification
           object: [self window]];
}



- (void) dealloc
{
  NSNotificationCenter* dc = [NSNotificationCenter defaultCenter];
  [dc removeObserver: self];
  
  [super dealloc];
}



@end


