//
//  WBMFormsPluginPanel.mm
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 1/Sep/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import "WBMFormsPluginPanel.h"
#include <mforms/mforms.h>
#import "cocoa/MFView.h"

@implementation WBMFormsPluginPanel


+ (WBMFormsPluginPanel*)panelOfAppView:(mforms::AppView*)view
{
  return (WBMFormsPluginPanel*)view->get_frontend_data();
}


- (id)initWithAppView:(mforms::AppView*)view
{
  self = [super init];
  if (self)
  {
    _owner = view;
    view->retain();
    view->set_frontend_data(self);
  }
  return self;
}

- (void) dealloc
{
  _owner->set_frontend_data(0);
  _owner->release();
  if (_defaultMenuBar)
    _defaultMenuBar->release();
  
  [super dealloc];
}


- (void)setDefaultMenuBar:(mforms::MenuBar*)menu
{
  _defaultMenuBar = menu;
}


- (NSMenu*)menuBar
{
  NSMenu *menu = [super menuBar];
  if (!menu && _defaultMenuBar)
    return _defaultMenuBar->get_data();
  return menu;
}


- (NSView*)topView
{
  return nsviewForView(_owner);
}


- (void)setTitle:(NSString*)title
{
  [_title autorelease];
  _title = [title retain];
}


- (NSString*)title
{
  return _title;
}


- (NSString*)identifier
{
  if (_owner->identifier().empty())
    return  [NSString stringWithFormat: @"mformsview%p", _owner];
  else
    return  [NSString stringWithUTF8String: _owner->identifier().c_str()];
}


- (NSImage*)tabIcon
{
  return nil;
}


- (bec::UIForm*)formBE
{
  return _owner;
}


- (NSSize)minimumSize
{
  return NSMakeSize(1, 1);
}


- (BOOL)willClose
{
  return _owner->on_close();
}


- (void)didOpen
{
}


@end
