//
//  WBOverviewComponents.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 18/Nov/08.
//  Copyright 2008 Sun Microsystems Inc. All rights reserved.
//

#import "sigobjc++.h"
#import <Cocoa/Cocoa.h>
#include "workbench/wb_overview.h"
#import "MVerticalLayoutView.h"
#import "WBSchemaTabView.h"

@class WBOverviewListController;
@class WBOverviewPanel;

typedef enum {
  ListModeLargeIcon,
  ListModeSmallIcon,
  ListModeDetails
} ListMode;

@interface WBOverviewGroupContainer : WBSchemaTabView
{
  WBOverviewPanel *_owner;
  wb::OverviewBE *_be;
  bec::NodeId *_nodeId;
  
  float _extraHeight;
  BOOL _updating;
}

- (id)initWithOverview:(WBOverviewPanel*)owner
                nodeId:(const bec::NodeId&)node;
- (void)refreshChildren;

- (void)buildChildren;

- (void)setLargeIconMode;
- (void)setSmallIconMode;
- (void)setDetailsMode;
- (void)performGroupAdd:(id)sender;
- (void)performGroupDelete:(id)sender;
@end



@interface WBOverviewGroup : MVerticalLayoutView
{
  WBOverviewPanel *_owner;
  wb::OverviewBE *_be;
  bec::NodeId *_nodeId;
  
  NSTabViewItem *_tabItem;
}

- (id)initWithOverview:(WBOverviewPanel*)owner
                nodeId:(const bec::NodeId&)node
               tabItem:(NSTabViewItem*)tabItem;

- (void)updateNodeId:(const bec::NodeId&)node;
- (bec::NodeId&)nodeId;

- (void)refreshChildren;
- (void)refreshInfo;

- (void)buildChildren;
- (void)setListMode: (ListMode) mode;

@end



@interface WBOverviewItemContainer : NSView
{
  WBOverviewPanel* _owner;
  wb::OverviewBE *_be;
  bec::NodeId *_nodeId;

  NSMutableArray *_nibObjects;
  
  wb::OverviewBE::OverviewDisplayMode _displayMode;

  NSTextField *_descriptionLabel;
  
  NSCollectionView *_iconView;
  WBOverviewListController *_iconController;
  
  NSTableView *_tableView;
  
  NSMenu *_contextMenu; // this is created in teh collectionView nib
}

- (id)initWithOverview:(WBOverviewPanel*)owner
                nodeId:(const bec::NodeId&)node;

- (void)updateNodeId:(const bec::NodeId&)node;

- (void)setDisplayMode:(wb::OverviewBE::OverviewDisplayMode)mode;

- (void)selectNode:(const bec::NodeId&)node;
- (void)clearSelection;

- (void)refreshChildren;
- (void)refreshChildInfo:(const bec::NodeId&)node;

@end



@interface WBOverviewSection : WBOverviewItemContainer 
{
  NSString *_title;
  NSString *_subTitle;
}

- (id)initWithOverview:(WBOverviewPanel*)owner
                nodeId:(const bec::NodeId&)node;


- (void)setTitle:(NSString*)title;
- (void)setSubTitle:(NSString*)title;

@end
