/* 
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _FILE_UTILITIES_H_
#define _FILE_UTILITIES_H_

#include "common.h"
#include <list>
#include <string>
#include <stdexcept>

namespace base
{
  BASELIBRARY_PUBLIC_FUNC std::list<std::string> scan_for_files_matching(const std::string &pattern,
    bool recursive = false);

  class file_locked_error : std::runtime_error
  {
  public:
    file_locked_error(const std::string &msg) : std::runtime_error(msg)
    {}
  };
  
  struct BASELIBRARY_PUBLIC_FUNC LockFile 
  {
#ifdef _WIN32
    #pragma warning(disable: 4251) // DLL interface required for std::string member.
    #pragma warning(disable: 4290) // C++ exception specification ignored.
    HANDLE handle;
#else
    int fd;
#endif

    std::string path;
    enum Status
    {
      LockedSelf, // lock file exists and is the process itself
      LockedOther, // lock file exists and its owner is running
      NotLocked,
    };
    
    LockFile(const std::string &path) throw (std::invalid_argument, std::runtime_error, file_locked_error);
    ~LockFile();
    
    static Status check(const std::string &path);
  };
};

#endif