/* 
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef __BASE_LOG_IMPL_H__
#define __BASE_LOG_IMPL_H__

#include <string>
#include "base/common.h"

namespace base
{

class BASELIBRARY_PUBLIC_FUNC Logger
{
  public:
    // Note: When adding or changing integer id of log level mind that 
    // the numbers must be sequential from 0 to N
    enum LogLevel {LogNone     = 0, 
                   LogError    = 1, 
                   LogWarning  = 2, 
                   LogInfo     = 3, 
                   LogDebug    = 4, 
                   LogDebug2   = 5, 
                   LogDebug3   = 6, 
                   NumOfLevels = LogDebug3};
    static void enable_level(const LogLevel level);
    static void disable_level(const LogLevel level);
    Logger(); // Later logdir or set of log files can be passed
    static void log(const LogLevel level, const char* const domain, const char* format, ...);
    static std::string get_state();
    static void set_state(const std::string& state);
  private:
    struct LoggerImpl;
    static LoggerImpl*  _impl;
};

} // End of namespace

#ifdef ENABLE_LOG

#undef log_error
#undef log_warning
#undef log_info
#undef log_debug
#undef log_debug2

// log_domain is defined by ENABLE_LOg macro from base/log.h
#define log_error(...) base::Logger::log(base::Logger::LogError, log_domain, __VA_ARGS__)
#define log_warning(...) base::Logger::log(base::Logger::LogWarning, log_domain, __VA_ARGS__)
#define log_info(...) base::Logger::log(base::Logger::LogInfo, log_domain, __VA_ARGS__)
#define log_debug(...) base::Logger::log(base::Logger::LogDebug, log_domain, __VA_ARGS__)
#define log_debug2(...) base::Logger::log(base::Logger::LogDebug2, log_domain, __VA_ARGS__)
#define log_debug3(...) base::Logger::log(base::Logger::LogDebug3, log_domain, __VA_ARGS__)

#endif // ifdef ENABLE_LOG

#endif

