/* 
 * Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _XML_UTIL_FUNCTIONS_H_
#define _XML_UTIL_FUNCTIONS_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "base/common.h"
//#include "util.h"

//#ifndef _WIN32
#include <libxml/tree.h>
//#endif

typedef char base_bool;

BASELIBRARY_PUBLIC_FUNC xmlDocPtr base_xmlParseFile(const char *filename);
BASELIBRARY_PUBLIC_FUNC int base_xmlSaveFile(const char *filename, xmlDocPtr doc);

BASELIBRARY_PUBLIC_FUNC char* int_to_str(int number);

BASELIBRARY_PUBLIC_FUNC char* bool_to_str(base_bool b);

BASELIBRARY_PUBLIC_FUNC int atoi_and_free(xmlChar *string);
BASELIBRARY_PUBLIC_FUNC double atof_and_free(xmlChar *string);

BASELIBRARY_PUBLIC_FUNC xmlChar* get_failsafe_utf8(const unsigned char* latin_str);

BASELIBRARY_PUBLIC_FUNC int file_exists(const char *filename);

BASELIBRARY_PUBLIC_FUNC long long file_size(const char *filename);

BASELIBRARY_PUBLIC_FUNC xmlNodePtr NewTextChild_int_content(xmlNodePtr parent,
                                                    xmlNsPtr ns, 
                                                    const xmlChar *name,
                                                    int content_int);
BASELIBRARY_PUBLIC_FUNC
      xmlNodePtr NewTextChild_double_content(xmlNodePtr parent, xmlNsPtr ns,
                                             const xmlChar *name,
                                             double content_double);

BASELIBRARY_PUBLIC_FUNC int get_child_count(const xmlNodePtr parent,
                                    const xmlChar *element_type_name);

BASELIBRARY_PUBLIC_FUNC void try_to_get_string_field(xmlDocPtr doc, xmlNodePtr cur,
                                             const char * name, char ** field);
BASELIBRARY_PUBLIC_FUNC void try_to_get_int_field(xmlDocPtr doc, xmlNodePtr cur,
                                          const char * name, int * field);
BASELIBRARY_PUBLIC_FUNC void try_to_get_char_field(xmlDocPtr doc, xmlNodePtr cur,
                                           const char * name, char * field);
BASELIBRARY_PUBLIC_FUNC void try_to_get_float_field(xmlDocPtr doc, xmlNodePtr cur,
                                           const char * name, double * field);

BASELIBRARY_PUBLIC_FUNC xmlNodePtr try_to_get_child(xmlDocPtr doc, 
                                            xmlNodePtr cur,
                                            const char * name);

#ifdef __cplusplus
}
#endif
#endif
