#ifndef _MDC_BOX_H_
#define _MDC_BOX_H_

#include "mdc_layouter.h"

BEGIN_MDC_DECLS


class MYSQLCANVAS_PUBLIC_FUNC Box : public Layouter {
public:
  enum Orientation {
    Horizontal,
    Vertical
  };
  
  Box(Layer *layer, Orientation orient= Horizontal, bool homogeneous= false);
  virtual ~Box();

  virtual void add(CanvasItem *item, bool expand, bool fill, bool hiddenspace= false);
  void insert_after(CanvasItem *after, CanvasItem *item, bool expand, bool fill, bool hiddenspace= false);
  void insert_before(CanvasItem *before, CanvasItem *item, bool expand, bool fill, bool hiddenspace= false);
  virtual void remove(CanvasItem *item);

  virtual void render(CairoCtx *cr);
  virtual Size calc_min_size();

  void set_spacing(float sp);

  virtual void foreach(const sigc::slot<void, CanvasItem*> &slot);

  virtual CanvasItem *get_item_at(const Point &pos);

  virtual void resize_to(const Size &size);
protected:
  struct BoxItem {
    CanvasItem *item;
    bool expand;
    bool fill;
    bool hiddenspace; // use for spacing calculation even when hidden
  };

  typedef std::list<BoxItem> ItemList;

  Orientation _orientation;
  ItemList _children;

  float _spacing;
  bool _homogeneous;
};


END_MDC_DECLS


#endif /* _MDC_BOX_H_ */
