#include "stdafx.h"


#include "mdc_straight_line_layouter.h"

#include "mdc_connector.h"


using namespace mdc;


StraightLineLayouter::StraightLineLayouter(Connector *sconn, Connector *econn)
   : _start_conn(sconn), _end_conn(econn)
{
  sconn->set_update_handler(sigc::mem_fun(this, &StraightLineLayouter::connector_changed));
  econn->set_update_handler(sigc::mem_fun(this, &StraightLineLayouter::connector_changed));

  _start= sconn->get_position();
  _end= econn->get_position();
}


StraightLineLayouter::~StraightLineLayouter()
{
  delete _start_conn;
  delete _end_conn;
}


std::vector<Point> StraightLineLayouter::get_points()
{
  std::vector<Point> p(2);
  p[0]= _start;
  p[1]= _end;

  return p;
}


Point StraightLineLayouter::get_start_point()
{
  return _start;
}


Point StraightLineLayouter::get_end_point()
{
  return _end;
}


void StraightLineLayouter::update()
{
  connector_changed(_start_conn);
}


void StraightLineLayouter::connector_changed(Connector *conn)
{
  Point p= conn->get_position();
  bool changed= false;

  if (conn == _start_conn)
  {
    mdc::CanvasItem *item= conn->get_connected_item();
    if (item)
      p= item->get_intersection_with_line_to(_end);

    if (_start != p)
    {
      _start= p;
      changed= true;
    }

    if (_end_conn)
    {
      item= _end_conn->get_connected_item();
      if (item)
      {
        p= item->get_intersection_with_line_to(_start);
        if (_end != p)
        {
          _end= p;
          changed= true;
        }
      }
    }
  }

  if (conn == _end_conn)
  {
    mdc::CanvasItem *item= conn->get_connected_item();
    if (item)
      p= item->get_intersection_with_line_to(_start);

    if (_end != p)
    {
      _end= p;
      changed= true;
    }

    if (_start_conn)
    {
      item= _start_conn->get_connected_item();
      if (item)
      {
        p= item->get_intersection_with_line_to(_end);
        if (_start != p)
        {
          _start= p;
          changed= true;
        }
      }
    }
  }
  if (changed)
    _changed.emit();
}

