//
//  MFCheckBox.mm
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 6/Feb/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import "MFCheckBox.h"

#import "MFView.h"
#include "mforms/mforms.h"

@implementation MFCheckBoxImpl


- (id)initWithObject:(::mforms::CheckBox*)aCheckBox
{
  self= [super initWithObject:aCheckBox buttonType: ::mforms::PushButton];
  if (self)
  {
    [self setButtonType: NSSwitchButton];
    [self setBezelStyle: NSRegularSquareBezelStyle];
    
    mTopLeftOffset= NSMakePoint(0, 0);
    mBottomRightOffset= NSMakePoint(0, 0);
    mAddPadding= NO;
    
    [self setTarget:self];
    [self setAction:@selector(performCallback:)];
  }
  return self;
}


- (void)performCallback:(id)sender
{
  mOwner->callback();
}


static bool checkbox_create(::mforms::CheckBox *self)
{
  [[[MFCheckBoxImpl alloc] initWithObject:self] autorelease];
  
  return true;  
}

static void checkbox_set_active(::mforms::CheckBox *self, bool flag)
{
  if ( self )
  {
    MFCheckBoxImpl* checkbox = self->get_data();
    
    if ( checkbox )
    {
      [checkbox setState: flag ? NSOnState : NSOffState];
    }
  }
}

static bool checkbox_get_active(::mforms::CheckBox *self)
{
  if ( self )
  {
    MFCheckBoxImpl* checkbox = self->get_data();
    
    if ( checkbox )
    {
      return [checkbox state] == NSOnState;
    }
  }
  return false;
}


void cf_checkbox_init()
{
  ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();
  
  f->_checkbox_impl.create= &checkbox_create;
  f->_checkbox_impl.set_active= &checkbox_set_active;
  f->_checkbox_impl.get_active= &checkbox_get_active;
}


@end

