/* 
 * Copyright (c) 2009, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#import "MFContainerBase.h"

@implementation MFContainerBase

- (BOOL)mouseDownCanMoveWindow
{
  return NO;
}

//--------------------------------------------------------------------------------------------------

- (id)initWithFrame:(NSRect)frameRect
{
  self = [super initWithFrame: frameRect];
  if (self != nil)
    mDefaultBackColor = [[NSColor colorWithDeviceWhite:232/255.0 alpha:1.0] retain];
  return self;
}

//--------------------------------------------------------------------------------------------------

- (void) dealloc
{
  [mDefaultBackColor release];
  [mBackColor release];
  [super dealloc];
}


//--------------------------------------------------------------------------------------------------

- (void)setPadding:(int)padding
{
  mPadding= padding;
}

//--------------------------------------------------------------------------------------------------

- (void)setTag:(NSInteger)tag
{
  mTag= tag;
}

//--------------------------------------------------------------------------------------------------

- (NSInteger)tag
{
  return mTag;
}

//--------------------------------------------------------------------------------------------------

- (void)setEnabled:(BOOL)flag
{
  for (id subview in [self subviews])
  {
    if ([subview respondsToSelector: @selector(setEnabled:)])
      [subview setEnabled: flag];
  }
}

//--------------------------------------------------------------------------------------------------

- (void)subviewMinimumSizeChanged
{
  NSSize minSize= [self preferredSize];
  NSSize size= [self frame].size;
  
  // size of some subview has changed, we check if our current size is enough
  // to fit it and if not, request forward the size change notification to superview
  
  if (mFreezeRelayout > 0)
    return;

  if (minSize.width != size.width || minSize.height != size.height)
  {
    if ([self superview])
    {
      [[self superview] subviewMinimumSizeChanged];
      return;
    }
    else
      [self setFrameSize: minSize];
  }
  [self resizeSubviewsWithOldSize:size];
}

//--------------------------------------------------------------------------------------------------

- (void)setFreezeRelayout:(BOOL)flag
{
  if (flag)
    mFreezeRelayout++;
  else
  {
    mFreezeRelayout--;
    if (mFreezeRelayout == 0)
    {
      [self subviewMinimumSizeChanged];
      [[self window] recalculateKeyViewLoop];
    }
  }
}

//--------------------------------------------------------------------------------------------------

- (void)setBackgroundColor: (NSColor*) color
{
  [mBackColor autorelease];
  mBackColor = [color retain];
  [self setNeedsDisplay: YES];
}

//--------------------------------------------------------------------------------------------------

/**
 * Fill the background of the container with the background color.
 */
- (void)drawRect: (NSRect) rect
{
  if (mBackColor != nil)
  {
    [mBackColor set];
    NSRectFill(rect);
  }
  else if (mDefaultBackColor != nil)
  {
    NSView *parent = [self superview];
    // check if we're inside a NSBox or NSTabView, which draw their own background
    while (parent)
    {
      if ([parent isKindOfClass: [NSBox class]] || ([parent isKindOfClass: objc_getClass("MFTabViewImpl")] && 
                                                    [(NSTabView*)parent tabViewType] != NSNoTabsNoBorder))
        break;
      parent = [parent superview];
    }
    if (!parent)
    {
      [mDefaultBackColor set];
      NSRectFill(rect);
    }
  }
}

//--------------------------------------------------------------------------------------------------

- (void)setBackgroundImage: (NSString*) path withLayout: (mforms::ImageLayout) layout
{
  
}

//--------------------------------------------------------------------------------------------------

@end
