#include "mforms/simplegrid.h"
#include "mforms/mforms.h"

using namespace mforms;

//------------------------------------------------------------------------------
SimpleGrid::SimpleGrid()
{
  _impl = &ControlFactory::get_instance()->_simple_grid_impl;
}

//------------------------------------------------------------------------------
int SimpleGrid::add_column(const std::string& name, mforms::CellsAccess access)
{
  return _impl->add_column(this, name, access);
}

//------------------------------------------------------------------------------
int SimpleGrid::add_text_column(const std::string& name, mforms::CellsAccess access)
{
  return _impl->add_text_column(this, name, access);
}

//------------------------------------------------------------------------------
int SimpleGrid::add_check_column(const std::string& name, mforms::CellsAccess access)
{
  return _impl->add_check_column(this, name, access);
}

//------------------------------------------------------------------------------
bool SimpleGrid::add_rows_group(const std::string& group_name)
{
  return _impl->add_rows_group(this, group_name);
}

//------------------------------------------------------------------------------
SimpleGrid::Path SimpleGrid::insert_row(const std::string& group_name, const int pos)
{
  return _impl->insert_row(this, group_name, pos);
}

//------------------------------------------------------------------------------
std::string SimpleGrid::get_group_for_row(const SimpleGrid::Path& pid)
{
  return _impl->get_group_for_row(this, pid);
}

//------------------------------------------------------------------------------
SimpleGrid::Value SimpleGrid::get_old_value(const SimpleGrid::Path& rid, const int col_id)
{
  return _impl->get_old_value(this, rid, col_id);
}

//------------------------------------------------------------------------------
SimpleGrid::Value SimpleGrid::get_value(const SimpleGrid::Path& rid, const int col_id)
{
  return _impl->get_value(this, rid, col_id);
}

//------------------------------------------------------------------------------
bool SimpleGrid::set_value(const SimpleGrid::Path& rid, const int col_id, const SimpleGrid::Value& cv)
{
  return _impl->set_value(this, rid, col_id, cv);
}

//------------------------------------------------------------------------------
bool SimpleGrid::set_enum_def(const SimpleGrid::Path& rid, const int col_id, const std::vector<std::string>& list)
{
  return _impl->set_enum_def(this, rid, col_id, list);
}

//------------------------------------------------------------------------------
bool SimpleGrid::set_validator(const SimpleGrid::Path& rid, const int col_id, SimpleGrid::ValidationSlot vs)
{
  return _impl->set_validator(this, rid, col_id, vs);
}

//------------------------------------------------------------------------------
bool SimpleGrid::set_validator_hinter(const SimpleGrid::Path& rid, const int col_id, SimpleGrid::ValidationHintSlot vs)
{
  return _impl->set_validator_hinter(this, rid, col_id, vs);
}

//------------------------------------------------------------------------------
void SimpleGrid::filter_rows(SimpleGrid::ProcessRowSlot slot)
{
  return _impl->filter_rows(this, slot);
}

//------------------------------------------------------------------------------
void SimpleGrid::reset_filter()
{
  return _impl->reset_filter(this);
}

//------------------------------------------------------------------------------
SimpleGrid::Path SimpleGrid::find_in_column(const SimpleGrid::Path& start, const int col_id, const SimpleGrid::Value& v)
{
  return _impl->find_in_column(this, start, col_id, v);
}

//------------------------------------------------------------------------------
SimpleGrid::Path SimpleGrid::find(const SimpleGrid::Path& start, SimpleGrid::FindSlot fslot)
{
  return _impl->find(this, start, fslot);
}

//------------------------------------------------------------------------------
void SimpleGrid::highlight(const SimpleGrid::Path& start, const int col_id)
{
  return _impl->highlight(this, start, col_id);
}

//------------------------------------------------------------------------------
void SimpleGrid::unhighlight(const SimpleGrid::Path& start, const int col_id)
{
  return _impl->unhighlight(this, start, col_id);
}
