/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

#include "mforms/mforms.h"

using namespace mforms;

  

TreeView::TreeView(TreeOptions options)
  : _context_menu(0), _updating(false)
{
  _treeview_impl= &ControlFactory::get_instance()->_treeview_impl;

  _treeview_impl->create(this, options);
}


void TreeView::set_context_menu(Menu *menu)
{
  _context_menu = menu;
}

int TreeView::add_column(TreeColumnType type, const std::string &name, int initial_width, bool editable)
{
  return _treeview_impl->add_column(this, type, name, initial_width, editable);
}


std::string TreeView::get_row_tag(int row)
{
  return _treeview_impl->get_row_tag(this, row);
}


void TreeView::set_row_tag(int row, const std::string &tag)
{
  _treeview_impl->set_row_tag(this, row, tag);
}

void TreeView::set_allow_sorting(bool flag)
{
  _treeview_impl->set_allow_sorting(this, flag);
}


void TreeView::end_columns()
{
  _treeview_impl->end_columns(this);
}


void TreeView::clear_rows()
{
  _treeview_impl->clear_rows(this);
}

  
void TreeView::delete_row(int row)
{
  _treeview_impl->delete_row(this, row);
}


int TreeView::add_row()
{
  return _treeview_impl->add_row(this);
}


int TreeView::get_selected()
{
  return _treeview_impl->get_selected(this);
}

void TreeView::set_selected(const int idx)
{
  _updating= true;
  _treeview_impl->set_selected(this, idx);
  _updating= false;
}


void TreeView::set_cell_edit_handler(const sigc::slot<void, int, int, std::string> &handler)
{
  _cell_edited = handler;
}


bool TreeView::cell_edited(int row, int column, const std::string &value)
{
  if (_cell_edited)
  {
    _cell_edited(row, column, value);
    return false;
  }
  return true;
}


int TreeView::count()
{
  return _treeview_impl->count(this);
}


void TreeView::set(int row, int column, const std::string &value)
{
  _treeview_impl->set_string(this, row, column, value);
}

void TreeView::set(int row, int column, int value)
{
  _treeview_impl->set_int(this, row, column, value);
}

void TreeView::set(int row, int column, bool check)
{
  _treeview_impl->set_check(this, row, column, check);
}


std::string TreeView::get_string(int row, int column)
{
  return _treeview_impl->get_string(this, row, column);
}

int TreeView::get_int(int row, int column)
{
  return _treeview_impl->get_int(this, row, column);
}
  
bool TreeView::get_check(int row, int column)
{
  return _treeview_impl->get_check(this, row, column);
}

void TreeView::changed()
{
  if (!_updating)
    _signal_changed.emit();
}

void TreeView::row_activated(int row, int column)
{
  _signal_activated.emit(row, column);
}


void TreeView::freeze_refresh()
{
  _treeview_impl->freeze_refresh(this, true);
}


void TreeView::thaw_refresh()
{
  _treeview_impl->freeze_refresh(this, false);
}

