/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WF_IMAGEBOX_H_
#define _WF_IMAGEBOX_H_

#include "mforms/mforms.h"
#include "mforms/app.h"

#include "wf_view.h"

using namespace System;
using namespace Windows::Forms;

namespace MySQL {
  namespace Forms {

    public ref class ImageBoxImpl : public ViewImpl
    {
      ImageBoxImpl(::mforms::ImageBox *image);

      static bool create(::mforms::ImageBox *self);
      static void set_image(::mforms::ImageBox *self, const std::string &file);
      static void set_image_align(::mforms::ImageBox *self, ::mforms::Alignment alignment);
      static void set_scale_contents(::mforms::ImageBox *self, bool flag);
    public:
      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK1(bool, ::mforms::ImageBox*, mgr, f->_imagebox_impl, ImageBoxImpl, create);
        DEF_CALLBACK2(void, ::mforms::ImageBox*, const std::string&, mgr, f->_imagebox_impl, ImageBoxImpl, set_image);
        DEF_CALLBACK2(void, ::mforms::ImageBox*, bool, mgr, f->_imagebox_impl, ImageBoxImpl, set_scale_contents);
        DEF_CALLBACK2(void, ::mforms::ImageBox*, ::mforms::Alignment, mgr, f->_imagebox_impl, ImageBoxImpl, set_image_align);
      }
    };

  };
};

#endif
