/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _GRTPP_MODULE_LUA_H_
#define _GRTPP_MODULE_LUA_H_

#include "grtpp.h"

#include "lua_context.h"

namespace grt {

  class LuaModuleLoader;
  
  class MYSQLGRT_PUBLIC LuaModule : public Module
  {
    friend class LuaModuleLoader;
  public:
    LuaModule(LuaModuleLoader *loader);
    virtual ~LuaModule();

  protected:

  };


  class MYSQLGRT_PUBLIC LuaModuleLoader : public ModuleLoader
  {
  public:
    LuaModuleLoader(GRT *grt);
    virtual ~LuaModuleLoader();
    
    virtual std::string get_loader_name() { return LanguageLua; }
    
    virtual Module *init_module(const std::string &path);

    virtual void refresh();
    
    virtual bool load_library(const std::string &file);

    LuaContext *get_lua_context() { return &_lua; }
    
    virtual bool check_file_extension(const std::string &path);
    virtual bool run_script_file(const std::string &path);
    virtual bool run_script(const std::string &script);

  protected:
    friend class LuaModule;

    LuaContext _lua;


    ValueRef call_function(const BaseListRef &args, LuaModule *module, const Module::Function &function);
  };

  
};

#endif
