using System;
using MySQL.Grt;

namespace MySQL.GUI.Workbench.Plugins
{
  public partial class NoteEditor : ObjectEditorPlugin
  {
    #region Member Variables

    private MySQL.Grt.NoteEditorBE noteEditorBE { get { return editorBE as MySQL.Grt.NoteEditorBE; } }

    #endregion

    #region Constructors

    protected NoteEditor()
    {
      InitializeComponent();
    }

    public NoteEditor(GrtManager GrtManager, GrtValue GrtObject)
      : base(new MySQL.Grt.NoteEditorBE(GrtManager, GrtObject))
    {
      InitializeComponent();

      // Init BE

      InitializingControls = true;
      try
      {
        RefreshFormData();
      }
      finally
      {
        InitializingControls = false;
      }

      //TabText = nameTextBox.Text;

      noteEditorBE.add_refresh_ui_handler(RefreshFormDataInvoke);
    }

    #endregion


    #region ObjectEditorPlugin Overrides

    public override bool ChangeGrtList(GrtManager GrtManager, GrtValue GrtList)
    {
      InitializingControls = true;
      SuspendLayout();

      try
      {
        grtManager = GrtManager;
        grtList = GrtList;

        if (editorBE != null)
          editorBE.disable_auto_refresh();
        editorBE = new MySQL.Grt.NoteEditorBE(GrtManager, GrtList);

        CallRefreshFormData();
      }
      finally
      {
        ResumeLayout();
        InitializingControls = false;
      }

      noteEditorBE.add_refresh_ui_handler(RefreshFormDataInvoke);

      Invalidate();

      return true;
    }

    #endregion

    #region IWorkbenchDocument implementation

    public override UIForm BackendClass
    {
      get { return editorBE; }
    }

    #endregion

    #region Form implemenation

    protected override void RefreshFormData()
    {
      sqlTextBox.Text = noteEditorBE.get_text();
      nameTextBox.Text = noteEditorBE.get_name();

      TabText = nameTextBox.Text;
    }

    #endregion

    private void sqlTextBox_TextChanged(object sender, EventArgs e)
    {
      if (!InitializingControls && sqlTextBox.Text != noteEditorBE.get_text())
        noteEditorBE.set_text(sqlTextBox.Text);
    }

    private void nameTextBox_TextChanged(object sender, EventArgs e)
    {
      if (!InitializingControls && nameTextBox.Text != noteEditorBE.get_name())
      {
        noteEditorBE.set_name(nameTextBox.Text);
        TabText = nameTextBox.Text;
      }
    }
  }
}