/* 
 * Copyright (c) 2007, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _GRTDBCONNECTPANEL_H_
#define _GRTDBCONNECTPANEL_H_

#include "wb_config.h"

#include <mforms/mforms.h>

#include "db_conn_be.h"

namespace grtui
{

class WBPUBLICBACKEND_PUBLIC_FUNC DbConnectPanel : public mforms::Box
{
public:
  DbConnectPanel(bool show_connection_combo= true);
  virtual ~DbConnectPanel();

  void init(const db_mgmt_ManagementRef &mgmt, const db_mgmt_ConnectionRef &default_conn=db_mgmt_ConnectionRef());
  void init(DbConnection *conn, const db_mgmt_ConnectionRef &default_conn=db_mgmt_ConnectionRef());
  
  void set_default_host_name(const std::string &host, bool update=false);
  std::string default_host_name() { return _default_host_name; }
  
  void set_skip_schema_name(bool flag);

  void set_enabled(bool flag);
  
  mforms::TextEntry *get_name_entry() { return  &_name_entry; }

  DbConnection *get_be() const { return _connection; }

  void set_active_stored_conn(int stored_conn_index);
  void set_active_driver(int driver_index);

  void get_connection_details(int &rdbms_index, int &driver_index);
  
  db_mgmt_ConnectionRef get_default_connection() { return _anonymous_connection; }
  
  db_mgmt_ConnectionRef get_connection();
  
  sigc::signal<void,std::string,bool> signal_validation_state_changed() { return _signal_validation_state_changed; }

  bool test_connection();
protected:
  DbConnection *_connection;
  db_mgmt_ConnectionRef _anonymous_connection;
  std::map<std::string, grt::DictRef> _parameters_per_driver;
  std::string _default_host_name;

  mforms::Table _table;
  mforms::Label _label1;
  mforms::Label _label2;
  mforms::Label _label3;
  
  mforms::TextEntry _name_entry;
  mforms::Selector _stored_connection_sel;
  mforms::Selector _rdbms_sel;
  mforms::Selector _driver_sel;
  mforms::Label _desc1;
  mforms::Label _desc2;
  mforms::Label _desc3;
  
  mforms::TabView _tab;


  mforms::Table _params_table;
  std::vector<mforms::Box*> _param_rows;

  mforms::Table _advanced_table;
  std::vector<mforms::Box*> _advanced_rows;

  std::list<mforms::View*> _views;
  
private:
  void save_param(const std::string& name, const grt::StringRef& param);
  std::string get_saved_param(const std::string& name);
  
  sigc::signal<void,std::string,bool> _signal_validation_state_changed;
  
  int _rdbms_index;
  int _driver_index;
  bool _initialized;
  bool _delete_connection_be;
  bool _show_connection_combo;
  bool _updating;
  bool _skip_schema_name;
  std::string _last_validation;

  void suspend_view_layout(bool flag);
  void clear_param_controls();
  void create_control(DbDriverParam *driver_param, ControlType ctrl_type, const MySQL::Geometry::ControlBounds& bounds,
    const std::string &caption);

  void set_active_rdbms(int rdbms_index,
                        int driver_index);
  
  void change_active_rdbms();
  void change_active_driver();
  
  void set_keychain_password(DbDriverParam *param, bool clear);
  
  void param_value_changed(mforms::View *sender);
  
  void refresh_stored_connections();
  
  void change_active_stored_conn();
  void reset_stored_conn_list();
  
  int open_editor();
};

};


#endif /* _GRTDBCONNECTFORM_H_ */
