/* 
 * Copyright (c) 2007, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */


#include "stdafx.h"

using namespace System;
using namespace System::Windows::Forms;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;

using namespace MySQL::Grt;
using namespace MySQL::Grt::Db;
using namespace MySQL::Grt::Db::Sql;
using namespace MySQL::Forms;

namespace MySQL {
namespace Grt {

long long nativeToManaged(::Recordset::Ref rs)
{
  return rs->key();
}
};

namespace GUI {
namespace Workbench {

Db_sql_editor::Db_sql_editor(boost::shared_ptr<::Db_sql_editor> *ptr)
{
  ::Db_sql_editor *inner= (::Db_sql_editor*)ptr->get();//(void*)ptr;

  _ref = new ::Db_sql_editor::Ref(*ptr);
  //_ref= gcnew ManagedRef<::Db_sql_editor>(
  //  new ManagedRef<::Db_sql_editor>::RefType(::Db_sql_editor::Ref(inner)));
  
  _refresh_ui = gcnew RefreshUI(inner);

  UIForm::init((*_ref).get());

  _log= Ref2Ptr_<::VarGridModel, VarGridModel>((*_ref)->log());
  _history= Ref2Ptr<::DbSqlEditorHistory, DbSqlEditorHistory>((*_ref)->history());

  exec_sql_task= gcnew GrtThreadedTask((*_ref)->exec_sql_task.get());

  action_list = gcnew ActionList(&(*_ref)->action_list());
}


Db_sql_editor::~Db_sql_editor()
{
 // if (!(void*)~_ref)
 //   return;
  delete _refresh_ui;
  delete action_list;
  delete exec_sql_task;
  delete _history;
  delete _log;
  (*_ref)->close();
  inner= NULL;
  delete _ref;
}


Recordset ^ Db_sql_editor::recordset(int index)
{
  return Ref2Ptr_<::Recordset, Recordset>((*_ref)->recordset(index));
}


void Db_sql_editor::active_recordset(Recordset ^val)
{
  if (nullptr == val)
    (*_ref)->active_recordset(::Recordset::Ref());
  else
    (*_ref)->active_recordset(*(::Recordset::Ref*)(void*)val->ref_intptr());
}

long long Db_sql_editor::active_recordset_for_sql_editor(int index)
{
  return (*_ref)->active_recordset_for_sql_editor(index);
}

void Db_sql_editor::recordset_list_changed_cb(Recordset_list_changed_cb::ManagedDelegate ^cb)
{
  _recordset_list_changed_cb= gcnew Recordset_list_changed_cb(cb);
  (*_ref)->recordset_list_changed.connect(_recordset_list_changed_cb->get_slot());
}


void Db_sql_editor::output_text_ui_cb(Output_text_ui_cb::ManagedDelegate ^cb)
{
  _output_text_ui_cb= gcnew Output_text_ui_cb(cb);
  (*_ref)->output_text_slot= _output_text_ui_cb->get_slot();
}


void Db_sql_editor::sql_editor_new_ui_cb(Sql_editor_new_ui_cb::ManagedDelegate ^cb)
{
  _sql_editor_new_ui_cb= gcnew Sql_editor_new_ui_cb(cb);
  (*_ref)->sql_editor_new_ui.connect(_sql_editor_new_ui_cb->get_slot());
}


void Db_sql_editor::sql_editor_text_insert_cb(Sql_editor_text_insert_cb::ManagedDelegate ^cb)
{
  _sql_editor_text_insert_cb= gcnew Sql_editor_text_insert_cb(cb);
  (*_ref)->sql_editor_text_insert_signal.connect(_sql_editor_text_insert_cb->get_slot());
}


String ^ Db_sql_editor::restore_sql_from_history(int entry_index, List<int> ^detail_indexes)
{
  std::list<int> detail_indexes_= NativeListToCppList<int,int>(detail_indexes);
  return CppStringToNative((*_ref)->restore_sql_from_history(entry_index, detail_indexes_));
}


List<String^>^ Db_sql_editor::schemata()
{
  std::list<std::string> schemata;
  (*_ref)->get_schemata(schemata);
  return CppStringListToNative2(schemata);
}


::MySQL::Workbench::Overview ^ Db_sql_editor::live_physical_overview()
{
  if (_live_physical_overview == nullptr)
    _live_physical_overview= gcnew ::MySQL::Workbench::Overview((*_ref)->live_physical_overview());
  return _live_physical_overview;
}


void Db_sql_editor::get_log_event_details(int log_event_no, [Out] int %log_event_type_code, [Out] String^ %log_event_time, [Out] String^ %log_event_action, [Out] String^ %log_event_message)
{
  int log_event_type_code_;
  std::string log_event_time_, log_event_action_, log_event_message_;
  (*_ref)->get_log_event_details(log_event_no, log_event_type_code_, log_event_time_, log_event_action_, log_event_message_);
  log_event_type_code= log_event_type_code_;
  log_event_time= CppStringToNative(log_event_time_);
  log_event_action= CppStringToNative(log_event_action_);
  log_event_message= CppStringToNative(log_event_message_);
}

//--------------------------------------------------------------------------------------------------

/**
 * Returns the native control which is behind the task side bar implementation, so the (C#) UI can
 * embed it. The sidebar is created on the way if not yet done.
 */
Control^ Db_sql_editor::get_sidebar_control()
{
  ViewImpl^ wrapper = (ViewImpl^) MySQL::Forms::ObjectImpl::FromUnmanaged((*_ref)->get_sidebar());
  return wrapper->GetControl();
}

//--------------------------------------------------------------------------------------------------

};  // namespace Workbench
};  // namespace GUI
};  // namespace MySQL
