/* 
 * Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

#include "sqlide/wb_sql_editor_form.h"

#include "Overview.h"
#include "FindDialogBE.h"
#include "Wb.h"

using namespace System::Threading;

namespace MySQL {
namespace Workbench {
  
//--------------------------------------------------------------------------------------------------

String^ WbContext::read_state(String^ name, String^ domain, String^ default_value)
{
  std::string value= inner->get_wb()->read_state(NativeToCppStringRaw(name), NativeToCppStringRaw(domain), 
    NativeToCppString(default_value));
  
  return CppStringToNative(value);
}

//--------------------------------------------------------------------------------------------------

int WbContext::read_state(String^ name, String^ domain, const int default_value)
{
  int value= inner->get_wb()->read_state(NativeToCppStringRaw(name), NativeToCppStringRaw(domain), 
    default_value);
  
  return value;
}

//--------------------------------------------------------------------------------------------------

double WbContext::read_state(String^ name, String^ domain, const double default_value)
{
  double value= inner->get_wb()->read_state(NativeToCppStringRaw(name), NativeToCppStringRaw(domain), 
    default_value);
  
  return value;
}

//--------------------------------------------------------------------------------------------------

bool WbContext::read_state(String^ name, String^ domain, const bool default_value)
{
  bool value= inner->get_wb()->read_state(NativeToCppStringRaw(name), NativeToCppStringRaw(domain), 
    default_value);
  
  return value;
}

//--------------------------------------------------------------------------------------------------

void WbContext::save_state(String^ name, String^ domain, String^ value)
{
  inner->get_wb()->save_state(NativeToCppStringRaw(name), NativeToCppStringRaw(domain), 
    NativeToCppString(value));
}

//--------------------------------------------------------------------------------------------------

void WbContext::save_state(String^ name, String^ domain, const int value)
{
  inner->get_wb()->save_state(NativeToCppStringRaw(name), NativeToCppStringRaw(domain), value);
}

//--------------------------------------------------------------------------------------------------

void WbContext::save_state(String^ name, String^ domain, const double value)
{
  inner->get_wb()->save_state(NativeToCppStringRaw(name), NativeToCppStringRaw(domain), value);
}

//--------------------------------------------------------------------------------------------------

void WbContext::save_state(String^ name, String^ domain, const bool value)
{
  inner->get_wb()->save_state(NativeToCppStringRaw(name), NativeToCppStringRaw(domain), value);
}

//--------------------------------------------------------------------------------------------------

String^ WbContext::read_option_value(String^ model, String^ key, String^ default_value)
{
  std::string raw_result;
  if (inner->get_wb_options_value(NativeToCppStringRaw(model), NativeToCppStringRaw(key), raw_result))
    return CppStringToNativeRaw(raw_result);
  else
    return default_value;
}

//--------------------------------------------------------------------------------------------------

void WbContext::set_create_main_form_view(MySQL::Forms::AppImpl^ application, VoidStrUIFormDelegate^ dt)
{
  create_main_form_view_delegate= dt;
  create_main_form_view_wrapper_delegate=
    gcnew VoidStrUIFormWrapperDelegate(this, &WbContext::create_main_form_view_wrapper);
  IntPtr ip = Marshal::GetFunctionPointerForDelegate(create_main_form_view_wrapper_delegate);
  VOID_STR_UIFORM_CB cb = static_cast<VOID_STR_UIFORM_CB>(ip.ToPointer());

  ::wb::WBFrontendCallbacks* callbacks = application->get_callbacks();
  callbacks->create_main_form_view= sigc::ptr_fun(cb);
}

//--------------------------------------------------------------------------------------------------

void WbContext::create_main_form_view_wrapper(const std::string& view_name, boost::shared_ptr<bec::UIForm> form_be)
{
  UIForm ^form = nullptr;

  if (0 == view_name.compare(WB_MAIN_VIEW_DB_QUERY))
  {
    boost::shared_ptr<::Db_sql_editor> ref(boost::static_pointer_cast<::Db_sql_editor>(form_be));
    form= gcnew MySQL::GUI::Workbench::Db_sql_editor(&ref);
  }

  create_main_form_view_delegate(CppStringToNativeRaw(view_name), form);
}

//--------------------------------------------------------------------------------------------------

MenuStrip^ WbContext::menu_for_form(MySQL::Grt::UIForm^ form)
{
  mforms::MenuBar* menu = NULL;
  
  if (form != nullptr)
    menu = form->get_unmanaged_object()->get_menubar();
  if (menu == NULL)
    menu = inner->get_command_ui()->create_menubar_for_context("");

  if (menu == NULL)
    return nullptr;

  MenuBarImpl^ menubar_impl = (MenuBarImpl^) ObjectImpl::FromUnmanaged(menu);

  return dynamic_cast<MenuStrip^>(menubar_impl->get_object());
}

//--------------------------------------------------------------------------------------------------

ToolStrip^ WbContext::toolbar_for_form(MySQL::Grt::UIForm^ form)
{
  mforms::ToolBar* toolbar = NULL;
  
  if (form != nullptr)
    toolbar = form->get_unmanaged_object()->get_toolbar();
  if (toolbar == NULL)
    return nullptr;

  ToolBarImpl^ toolbar_impl = (ToolBarImpl^) ViewImpl::FromUnmanaged(toolbar);

  return dynamic_cast<ToolStrip^>(toolbar_impl->get_object());
}

//--------------------------------------------------------------------------------------------------

} // namespace Workbench
} // namespace MySQL
