/* 
 * Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WIN32API_
#define _WIN32API_

// Helper class to access native Windows functions. Avoids using P/Invoke from C#.
// In the mid term, remove P/Invoke code from Win32.cs and do native calls here.

using namespace System::Windows::Forms;

namespace MySQL {
namespace Utilities {
namespace SysUtils {

  public ref class Win32Api
  {
  public:
    // Clipboard operations for editable combo boxes.
    static void Undo(ComboBox^ box);
    static void Cut(ComboBox^ box);
    static void Copy(ComboBox^ box);
    static void Paste(ComboBox^ box);
    static bool CanUndo(ComboBox^ box);

    static bool UnblockWorkbenchFiles(String^ folder);
    static bool UnblockFile(String^ file);
  };

} // SysUtilits
} // Utilities
} // MySQL
#endif // _WIN32API_