#ifndef __DB_OBJECT_FILTER_BE_WRAPPER_H__
#define __DB_OBJECT_FILTER_BE_WRAPPER_H__

#include "grtdb/db_object_filter.h"

#ifdef _MSC_VER
using namespace System;
using namespace System::Collections::Generic;
using namespace System::Runtime::InteropServices;
#endif

//#pragma make_public(::bec::DBObjectFilterBE)(removed because it throws some metadata error on link -alfredo)

namespace MySQL {
namespace Grt {
namespace Db {

ref class DBObjectFilterBE;

public ref class DBObjectFilterBE
{
protected:
  ::bec::DBObjectFilterBE *inner;

  DBObjectFilterBE(::bec::DBObjectFilterBE *inn) 
    : inner(inn)
  {}  

public:
  DBObjectFilterBE(MySQL::Grt::GrtManager^ grtm);

  ~DBObjectFilterBE()
  { delete inner; }

  ::bec::DBObjectFilterBE *get_unmanaged_object()
  { return static_cast<::bec::DBObjectFilterBE *>(inner); }

  void set_object_type_name(String^ type_name);
  String^ get_full_type_name();
  int icon_id(MySQL::Grt::IconSize icon_size);

  void filter_model(GrtStringListModel^ filter_model);
  GrtStringListModel^ filter_model();
  void add_stored_filter_set(String^ name);
  void remove_stored_filter_set(int index);
  void load_stored_filter_set(int index);
  void load_stored_filter_set_list(List<String ^> ^%names);
};

} // namespace Db
} // namespace Grt
} // namespace MySQL

#endif /* __DB_OBJECT_FILTER_BE_WRAPPER_H__ */