#ifndef __SCHEMA_EDITOR_H__
#define __SCHEMA_EDITOR_H__

#include "DBObjectEditorBE.h"
#include "GrtTemplates.h"
#include "grtdb/editor_schema.h"

#pragma make_public(::bec::SchemaEditorBE)

namespace MySQL {
namespace Grt {
namespace Db {

public ref class SchemaEditorBE : public DBObjectEditorBE
{
protected:
  SchemaEditorBE(::bec::SchemaEditorBE *inn)
    : DBObjectEditorBE(inn)
  {}

public:
  SchemaEditorBE::SchemaEditorBE(MySQL::Grt::GrtManager^ grtm, MySQL::Grt::GrtValue^ args)
  : DBObjectEditorBE(
        new bec::SchemaEditorBE(grtm->get_unmanaged_object(), 
          db_SchemaRef::cast_from(grt::BaseListRef::cast_from(args->get_unmanaged_object()).get(0)), 
          get_rdbms_for_db_object(grt::BaseListRef::cast_from(args->get_unmanaged_object()).get(0)))
      )
  {
  }


  ::bec::SchemaEditorBE *get_unmanaged_object()
  { return static_cast<::bec::SchemaEditorBE *>(inner); }

  void set_schema_option_by_name(System::String^ name, System::String^ value)
  { get_unmanaged_object()->set_schema_option_by_name(NativeToCppString(name), NativeToCppString(value)); }

  String^ get_schema_option_by_name(String^ name)
  { return CppStringToNative(get_unmanaged_object()->get_schema_option_by_name(NativeToCppString(name))); }

};

} // namespace Db
} // namespace Grt
} // namespace MySQL

#endif // __SCHEMA_EDITOR_H__