#ifndef __RECORDSET_VIEW_H__
#define __RECORDSET_VIEW_H__


#include "sqlide/grid_view.h"
#include "sqlide/recordset_be.h"
#include <gtkmm.h>


class RecordsetView : public Gtk::Frame
{
public:
  static RecordsetView * create(Recordset::Ref model, Gtk::Container *parent);
  ~RecordsetView();
protected:
  RecordsetView(Recordset::Ref model);
private:
  virtual void init();

public:
  void model(Recordset::Ref value);
  Recordset::Ref model() { return _model; }
protected:
  Recordset::Ref _model;
  GridView *_grid;
  Gtk::Box *_toolbar_box;

protected:
  Gtk::TextView *_messages_view;
  Gtk::Container *_messages_window;
  Gtk::Button *_close_btn;
  Gtk::Entry *_filter_entry;

public:
  virtual int refresh();
  virtual void reset();

  void save_changes();
  void revert_changes();
  
  bool has_changes();
  
protected:
  virtual int process_task_msg(int msg_type, const std::string &message, const std::string &detail);

  virtual bool on_event(GdkEvent *event);

  void on_commit_btn_clicked();
  void on_rollback_btn_clicked();
  
  void on_goto_first_row_btn_clicked();
  void on_goto_last_row_btn_clicked();
  void on_record_prev();
  void on_record_next();
  void on_record_edit();
  void on_record_add();
  void on_record_del();
  void on_record_sort_asc();
  void on_record_sort_desc();
  
  void update_toolbar();
  Gtk::Widget *create_toolbar_item(const bec::ToolbarItem &item);

  bool activate_toolbar_item(const std::string &action);
  bool on_data_search_entry_key_pressed(GdkEventKey *event, Gtk::Entry *search_entry);
};


#endif // __RECORDSET_VIEW_H__
